package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * Use the <strong>HTML <code>&lt;canvas&gt;</code> element</strong> with the <a href="/en-US/docs/Web/API/Canvas_API">canvas scripting API </a>to draw graphics and animations.
 */
object canvas extends Tag {
implicit object tag extends TagElement {
  type RefType = org.scalajs.dom.html.Canvas
}
type tagType = tag.type

@inline def apply(mods: TagMod[tag.type]*): WithAttrs[tagType] = {
  WithAttrs("canvas", mods)
}


}

object _canvas_attr {

}
