package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * <p>When the value of the <strong>type</strong> attribute is <code>file</code>, the presence of this Boolean attribute indicates that capture of media directly from the device's environment using a <a class="external" href="https://www.w3.org/TR/html-media-capture/#dfn-media-capture-mechanism">media capture mechanism</a> is preferred.</p>
 */
object capture extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: Boolean) = new AttrPair[_capture_attr.type]("capture", v)
@inline def :=(v: Option[Boolean]) = new OptionalAttrPair[_capture_attr.type]("capture", v)
type attrType = _capture_attr.type
@inline implicit def boolToPairinputApplied(attrObj: this.type) = new AttrPair[input.tag.type]("capture", true)
@inline implicit def boolToPairstarApplied(attrObj: this.type) = new AttrPair[*.tag.type]("capture", true)
}

object _capture_attr {
@inline implicit def toinputApplied(pair: AttrPair[_capture_attr.type]) = pair.asInstanceOf[AttrPair[input.tag.type]]
@inline implicit def toinputOptionalApplied(pair: OptionalAttrPair[_capture_attr.type]) = pair.asInstanceOf[OptionalAttrPair[input.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_capture_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_capture_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
