package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * A challenge string that is submitted along with the public key. Defaults to an empty string if not specified.
 */
object challenge extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: String) = new AttrPair[_challenge_attr.type]("challenge", v)
@inline def :=(v: Option[String]) = new OptionalAttrPair[_challenge_attr.type]("challenge", v)
type attrType = _challenge_attr.type

}

object _challenge_attr {
@inline implicit def tokeygenApplied(pair: AttrPair[_challenge_attr.type]) = pair.asInstanceOf[AttrPair[keygen.tag.type]]
@inline implicit def tokeygenOptionalApplied(pair: OptionalAttrPair[_challenge_attr.type]) = pair.asInstanceOf[OptionalAttrPair[keygen.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_challenge_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_challenge_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
