package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * menuitem - Boolean attribute which indicates whether the command is selected. May only be used when the <code>type</code> attribute is <code>checkbox</code> or <code>radio</code>.
 * input - <p>When the value of the <strong>type</strong> attribute is <code>radio</code> or <code>checkbox</code>, the presence of this Boolean attribute indicates that the control is selected by default,&nbsp;otherwise it is ignored.</p> <p>Unlike other browsers, Firefox will by default <a class="external" href="https://stackoverflow.com/questions/5985839/bug-with-firefox-disabled-attribute-of-input-not-resetting-when-refreshing">persist the dynamic checked state</a> of an <code>&lt;input&gt;</code> across page loads. Use the <code><a href="/en-US/docs/Web/HTML/Element/input#attr-autocomplete">autocomplete</a></code> attribute to control this feature.</p>
 */
object checked extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: Boolean) = new AttrPair[_checked_attr.type]("checked", v)
@inline def :=(v: Option[Boolean]) = new OptionalAttrPair[_checked_attr.type]("checked", v)
type attrType = _checked_attr.type
@inline implicit def boolToPairinputApplied(attrObj: this.type) = new AttrPair[input.tag.type]("checked", true)
@inline implicit def boolToPairmenuitemApplied(attrObj: this.type) = new AttrPair[menuitem.tag.type]("checked", true)
@inline implicit def boolToPairstarApplied(attrObj: this.type) = new AttrPair[*.tag.type]("checked", true)
}

object _checked_attr {
@inline implicit def toinputApplied(pair: AttrPair[_checked_attr.type]) = pair.asInstanceOf[AttrPair[input.tag.type]]
@inline implicit def toinputOptionalApplied(pair: OptionalAttrPair[_checked_attr.type]) = pair.asInstanceOf[OptionalAttrPair[input.tag.type]]
             
@inline implicit def tomenuitemApplied(pair: AttrPair[_checked_attr.type]) = pair.asInstanceOf[AttrPair[menuitem.tag.type]]
@inline implicit def tomenuitemOptionalApplied(pair: OptionalAttrPair[_checked_attr.type]) = pair.asInstanceOf[OptionalAttrPair[menuitem.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_checked_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_checked_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
