package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * The <strong>HTML &lt;cite&gt; element</strong> represents a reference to a creative work. It must include the title of a work or a URL reference, which may be in an abbreviated form according to the conventions used for the addition of citation metadata.
 * ins - This attribute defines the URI of a resource that explains the change, such as a link to meeting minutes or a ticket in a troubleshooting sytem.
 * q - The value of this attribute is a URL that designates a source document or message for the information quoted. This attribute is intended to point to information explaining the context or the reference for the quote.
 * del - A URI for a resource that explains the change (for example, meeting minutes).
 * blockquote - A URL that designates a source document or message for the information quoted. This attribute is intended to point to information explaining the context or the reference for the quote.
 */
object cite extends Tag with Attr {
implicit object tag extends TagElement {
  type RefType = org.scalajs.dom.html.Element
}
type tagType = tag.type

@inline def apply(mods: TagMod[tag.type]*): WithAttrs[tagType] = {
  WithAttrs("cite", mods)
}
@inline def :=(v: String) = new AttrPair[_cite_attr.type]("cite", v)
@inline def :=(v: Option[String]) = new OptionalAttrPair[_cite_attr.type]("cite", v)
type attrType = _cite_attr.type

}

object _cite_attr {
@inline implicit def toblockquoteApplied(pair: AttrPair[_cite_attr.type]) = pair.asInstanceOf[AttrPair[blockquote.tag.type]]
@inline implicit def toblockquoteOptionalApplied(pair: OptionalAttrPair[_cite_attr.type]) = pair.asInstanceOf[OptionalAttrPair[blockquote.tag.type]]
             
@inline implicit def todelApplied(pair: AttrPair[_cite_attr.type]) = pair.asInstanceOf[AttrPair[del.tag.type]]
@inline implicit def todelOptionalApplied(pair: OptionalAttrPair[_cite_attr.type]) = pair.asInstanceOf[OptionalAttrPair[del.tag.type]]
             
@inline implicit def toinsApplied(pair: AttrPair[_cite_attr.type]) = pair.asInstanceOf[AttrPair[ins.tag.type]]
@inline implicit def toinsOptionalApplied(pair: OptionalAttrPair[_cite_attr.type]) = pair.asInstanceOf[OptionalAttrPair[ins.tag.type]]
             
@inline implicit def toqApplied(pair: AttrPair[_cite_attr.type]) = pair.asInstanceOf[AttrPair[q.tag.type]]
@inline implicit def toqOptionalApplied(pair: OptionalAttrPair[_cite_attr.type]) = pair.asInstanceOf[OptionalAttrPair[q.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_cite_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_cite_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
