package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * pre - Contains the <em>preferred</em> count of characters that a line should have. It was a non-standard synonym of <code><a href="/en-US/docs/Web/HTML/Element/pre#attr-width">width</a></code>. To achieve such an effect, use CSS <a title="The width property specifies the width of an element. By default, the property defines the width of the content area. If box-sizing is set to border-box, it instead determines the width of the border area." href="/en-US/docs/Web/CSS/width"><code>width</code></a> instead.
 * textarea - The visible width of the text control, in average character widths. If it is specified, it must be a positive integer. If it is not specified, the default value is <code>20</code> (HTML5).
 */
object cols extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: String) = new AttrPair[_cols_attr.type]("cols", v)
@inline def :=(v: Option[String]) = new OptionalAttrPair[_cols_attr.type]("cols", v)
type attrType = _cols_attr.type

}

object _cols_attr {
@inline implicit def topreApplied(pair: AttrPair[_cols_attr.type]) = pair.asInstanceOf[AttrPair[pre.tag.type]]
@inline implicit def topreOptionalApplied(pair: OptionalAttrPair[_cols_attr.type]) = pair.asInstanceOf[OptionalAttrPair[pre.tag.type]]
             
@inline implicit def totextareaApplied(pair: AttrPair[_cols_attr.type]) = pair.asInstanceOf[AttrPair[textarea.tag.type]]
@inline implicit def totextareaOptionalApplied(pair: OptionalAttrPair[_cols_attr.type]) = pair.asInstanceOf[OptionalAttrPair[textarea.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_cols_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_cols_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
