package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * This attribute contains the value for the <code><a href="/en-US/docs/Web/HTML/Element/meta#attr-http-equiv">http-equiv</a></code> or <code><a href="/en-US/docs/Web/HTML/Element/meta#attr-name">name</a></code> attribute, depending on which was used.
 */
object content extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: String) = new AttrPair[_content_attr.type]("content", v)
@inline def :=(v: Option[String]) = new OptionalAttrPair[_content_attr.type]("content", v)
type attrType = _content_attr.type

}

object _content_attr {
@inline implicit def tometaApplied(pair: AttrPair[_content_attr.type]) = pair.asInstanceOf[AttrPair[meta.tag.type]]
@inline implicit def tometaOptionalApplied(pair: OptionalAttrPair[_content_attr.type]) = pair.asInstanceOf[OptionalAttrPair[meta.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_content_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_content_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
