package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * audio - If this attribute is present, the browser will offer controls to allow the user to control audio playback, including volume, seeking, and pause/resume playback.
 * video - If this attribute is present, the browser will offer controls to allow the user to control video playback, including volume, seeking, and pause/resume playback.
 */
object controls extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: Boolean) = new AttrPair[_controls_attr.type]("controls", v)
@inline def :=(v: Option[Boolean]) = new OptionalAttrPair[_controls_attr.type]("controls", v)
type attrType = _controls_attr.type
@inline implicit def boolToPairaudioApplied(attrObj: this.type) = new AttrPair[audio.tag.type]("controls", true)
@inline implicit def boolToPairvideoApplied(attrObj: this.type) = new AttrPair[video.tag.type]("controls", true)
@inline implicit def boolToPairstarApplied(attrObj: this.type) = new AttrPair[*.tag.type]("controls", true)
}

object _controls_attr {
@inline implicit def toaudioApplied(pair: AttrPair[_controls_attr.type]) = pair.asInstanceOf[AttrPair[audio.tag.type]]
@inline implicit def toaudioOptionalApplied(pair: OptionalAttrPair[_controls_attr.type]) = pair.asInstanceOf[OptionalAttrPair[audio.tag.type]]
             
@inline implicit def tovideoApplied(pair: AttrPair[_controls_attr.type]) = pair.asInstanceOf[AttrPair[video.tag.type]]
@inline implicit def tovideoOptionalApplied(pair: OptionalAttrPair[_controls_attr.type]) = pair.asInstanceOf[OptionalAttrPair[video.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_controls_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_controls_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
