package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * a - For use with the below <code>shape</code> attribute, this attribute used a comma-separated list of numbers to define the coordinates of the link on the page.
 * area - A set of values specifying the coordinates of the hot-spot region. The number and meaning of the values depend upon the value specified for the <strong>shape</strong> attribute. For a <code>rect</code> or rectangle shape, the <strong>coords</strong> value is two x,y pairs: left, top, right, and bottom. For a <code>circle</code> shape, the value is <code>x,y,r</code> where <code>x,y</code> is a pair specifying the center of the circle and <code>r</code> is a value for the radius. For a <code>poly</code> or polygon&nbsp;shape, the value is a set of x,y pairs for each point in the polygon: <code>x1,y1,x2,y2,x3,y3,</code> and so on. In HTML4, the values are numbers of pixels or percentages, if a percent sign (%) is appended; in HTML5, the values are numbers of CSS&nbsp;pixels.
 */
object coords extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: String) = new AttrPair[_coords_attr.type]("coords", v)
@inline def :=(v: Option[String]) = new OptionalAttrPair[_coords_attr.type]("coords", v)
type attrType = _coords_attr.type

}

object _coords_attr {
@inline implicit def toaApplied(pair: AttrPair[_coords_attr.type]) = pair.asInstanceOf[AttrPair[a.tag.type]]
@inline implicit def toaOptionalApplied(pair: OptionalAttrPair[_coords_attr.type]) = pair.asInstanceOf[OptionalAttrPair[a.tag.type]]
             
@inline implicit def toareaApplied(pair: AttrPair[_coords_attr.type]) = pair.asInstanceOf[AttrPair[area.tag.type]]
@inline implicit def toareaOptionalApplied(pair: OptionalAttrPair[_coords_attr.type]) = pair.asInstanceOf[OptionalAttrPair[area.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_coords_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_coords_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
