package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * The <strong>HTML <code>&lt;data&gt;</code> element</strong> links a given content with a machine-readable translation. If the content is time- or date-related, the <a title="The HTML <time> element represents either a time on a 24-hour clock or a precise date in the Gregorian calendar (with optional time and timezone information)." href="/en-US/docs/Web/HTML/Element/time"><code>&lt;time&gt;</code></a> element must be used.
 * object - The address of the resource as a valid URL. At least one of <strong>data</strong> and <strong>type</strong> must be defined.
 * a, abbr, address, area, article, aside, audio, b, base, bdi, bdo, big, blockquote, body, br, button, canvas, caption, cite, code, col, colgroup, data, datalist, dd, del, details, dfn, dialog, div, dl, dt, em, embed, fieldset, figcaption, figure, footer, form, h1, h2, h3, h4, h5, h6, head, header, hr, html, i, iframe, img, input, ins, kbd, keygen, label, legend, li, link, main, map, mark, menu, menuitem, meta, meter, nav, noscript, object, ol, optgroup, option, output, p, param, picture, pre, progress, q, rp, rt, ruby, s, samp, script, section, select, small, source, span, strong, style, sub, summary, sup, table, tbody, td, textarea, tfoot, th, thead, time, title, tr, track, u, ul, var, video, wbr - Forms a class of attributes, called custom data attributes, that allow proprietary information to be exchanged between the 
<a href="/en-US/docs/Web/HTML">HTML</a> and its 
<a href="/en-US/docs/Glossary/DOM">DOM</a> representation that may be used by scripts. All such custom data are available via the 
<a title="The HTMLElement interface represents any HTML element. Some elements directly implement this interface, others implement it via an interface that inherits it." href="/en-US/docs/Web/API/HTMLElement"><code>HTMLElement</code></a> interface of the element the attribute is set on. The 
<a title="The HTMLElement.dataset property allows access, both in reading and writing mode, to all the custom data attributes (data-&#47;) set on the element, either in HTML or in the DOM. &nbsp;It is a map of DOMString, one entry for each custom data attribute. &nbsp;Note that the&nbsp;dataset&nbsp;property itself can be read, but not&nbsp;directly written. &nbsp;Instead, all writes must be&nbsp;to its &quot;properties&quot;, which in turn represent the data attributes. &nbsp; Note also that an HTML data-attribute&nbsp;and its&nbsp;corresponding DOM&nbsp;dataset.property&nbsp;do not share the same name, but they are always similar:" href="/en-US/docs/Web/API/HTMLElement/dataset"><code>HTMLElement.dataset</code></a> property gives access to them.
 */
object data extends Tag with Attr {
implicit object tag extends TagElement {
  type RefType = org.scalajs.dom.html.Element
}
type tagType = tag.type

@inline def apply(mods: TagMod[tag.type]*): WithAttrs[tagType] = {
  WithAttrs("data", mods)
}
@inline def :=(v: String) = new AttrPair[_data_attr.type]("data", v)
@inline def :=(v: Option[String]) = new OptionalAttrPair[_data_attr.type]("data", v)
type attrType = _data_attr.type
final class WithDash(@inline private val sub: String) extends AnyVal {
@inline def :=(v: String) = new AttrPair[_data_attr.type]("data-" + sub, v)
@inline def :=(v: Option[String]) = new OptionalAttrPair[_data_attr.type]("data-" + sub, v) }
@inline def -(sub: String) = new WithDash(sub)

}

object _data_attr {
@inline implicit def toaApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[a.tag.type]]
@inline implicit def toaOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[a.tag.type]]
             
@inline implicit def toabbrApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[abbr.tag.type]]
@inline implicit def toabbrOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[abbr.tag.type]]
             
@inline implicit def toaddressApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[address.tag.type]]
@inline implicit def toaddressOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[address.tag.type]]
             
@inline implicit def toareaApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[area.tag.type]]
@inline implicit def toareaOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[area.tag.type]]
             
@inline implicit def toarticleApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[article.tag.type]]
@inline implicit def toarticleOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[article.tag.type]]
             
@inline implicit def toasideApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[aside.tag.type]]
@inline implicit def toasideOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[aside.tag.type]]
             
@inline implicit def toaudioApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[audio.tag.type]]
@inline implicit def toaudioOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[audio.tag.type]]
             
@inline implicit def tobApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[b.tag.type]]
@inline implicit def tobOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[b.tag.type]]
             
@inline implicit def tobaseApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[base.tag.type]]
@inline implicit def tobaseOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[base.tag.type]]
             
@inline implicit def tobdiApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[bdi.tag.type]]
@inline implicit def tobdiOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[bdi.tag.type]]
             
@inline implicit def tobdoApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[bdo.tag.type]]
@inline implicit def tobdoOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[bdo.tag.type]]
             
@inline implicit def tobigApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[big.tag.type]]
@inline implicit def tobigOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[big.tag.type]]
             
@inline implicit def toblockquoteApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[blockquote.tag.type]]
@inline implicit def toblockquoteOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[blockquote.tag.type]]
             
@inline implicit def tobodyApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[body.tag.type]]
@inline implicit def tobodyOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[body.tag.type]]
             
@inline implicit def tobrApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[br.tag.type]]
@inline implicit def tobrOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[br.tag.type]]
             
@inline implicit def tobuttonApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[button.tag.type]]
@inline implicit def tobuttonOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[button.tag.type]]
             
@inline implicit def tocanvasApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[canvas.tag.type]]
@inline implicit def tocanvasOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[canvas.tag.type]]
             
@inline implicit def tocaptionApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[caption.tag.type]]
@inline implicit def tocaptionOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[caption.tag.type]]
             
@inline implicit def tociteApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[cite.tag.type]]
@inline implicit def tociteOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[cite.tag.type]]
             
@inline implicit def tocodeApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[code.tag.type]]
@inline implicit def tocodeOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[code.tag.type]]
             
@inline implicit def tocolApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[col.tag.type]]
@inline implicit def tocolOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[col.tag.type]]
             
@inline implicit def tocolgroupApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[colgroup.tag.type]]
@inline implicit def tocolgroupOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[colgroup.tag.type]]
             
@inline implicit def todataApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[data.tag.type]]
@inline implicit def todataOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[data.tag.type]]
             
@inline implicit def todatalistApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[datalist.tag.type]]
@inline implicit def todatalistOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[datalist.tag.type]]
             
@inline implicit def toddApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[dd.tag.type]]
@inline implicit def toddOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[dd.tag.type]]
             
@inline implicit def todelApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[del.tag.type]]
@inline implicit def todelOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[del.tag.type]]
             
@inline implicit def todetailsApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[details.tag.type]]
@inline implicit def todetailsOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[details.tag.type]]
             
@inline implicit def todfnApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[dfn.tag.type]]
@inline implicit def todfnOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[dfn.tag.type]]
             
@inline implicit def todialogApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[dialog.tag.type]]
@inline implicit def todialogOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[dialog.tag.type]]
             
@inline implicit def todivApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[div.tag.type]]
@inline implicit def todivOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[div.tag.type]]
             
@inline implicit def todlApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[dl.tag.type]]
@inline implicit def todlOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[dl.tag.type]]
             
@inline implicit def todtApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[dt.tag.type]]
@inline implicit def todtOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[dt.tag.type]]
             
@inline implicit def toemApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[em.tag.type]]
@inline implicit def toemOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[em.tag.type]]
             
@inline implicit def toembedApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[embed.tag.type]]
@inline implicit def toembedOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[embed.tag.type]]
             
@inline implicit def tofieldsetApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[fieldset.tag.type]]
@inline implicit def tofieldsetOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[fieldset.tag.type]]
             
@inline implicit def tofigcaptionApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[figcaption.tag.type]]
@inline implicit def tofigcaptionOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[figcaption.tag.type]]
             
@inline implicit def tofigureApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[figure.tag.type]]
@inline implicit def tofigureOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[figure.tag.type]]
             
@inline implicit def tofooterApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[footer.tag.type]]
@inline implicit def tofooterOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[footer.tag.type]]
             
@inline implicit def toformApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[form.tag.type]]
@inline implicit def toformOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[form.tag.type]]
             
@inline implicit def toh1Applied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[h1.tag.type]]
@inline implicit def toh1OptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[h1.tag.type]]
             
@inline implicit def toh2Applied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[h2.tag.type]]
@inline implicit def toh2OptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[h2.tag.type]]
             
@inline implicit def toh3Applied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[h3.tag.type]]
@inline implicit def toh3OptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[h3.tag.type]]
             
@inline implicit def toh4Applied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[h4.tag.type]]
@inline implicit def toh4OptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[h4.tag.type]]
             
@inline implicit def toh5Applied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[h5.tag.type]]
@inline implicit def toh5OptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[h5.tag.type]]
             
@inline implicit def toh6Applied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[h6.tag.type]]
@inline implicit def toh6OptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[h6.tag.type]]
             
@inline implicit def toheadApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[head.tag.type]]
@inline implicit def toheadOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[head.tag.type]]
             
@inline implicit def toheaderApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[header.tag.type]]
@inline implicit def toheaderOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[header.tag.type]]
             
@inline implicit def tohrApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[hr.tag.type]]
@inline implicit def tohrOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[hr.tag.type]]
             
@inline implicit def tohtmlApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[html.tag.type]]
@inline implicit def tohtmlOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[html.tag.type]]
             
@inline implicit def toiApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[i.tag.type]]
@inline implicit def toiOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[i.tag.type]]
             
@inline implicit def toiframeApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[iframe.tag.type]]
@inline implicit def toiframeOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[iframe.tag.type]]
             
@inline implicit def toimgApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[img.tag.type]]
@inline implicit def toimgOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[img.tag.type]]
             
@inline implicit def toinputApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[input.tag.type]]
@inline implicit def toinputOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[input.tag.type]]
             
@inline implicit def toinsApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[ins.tag.type]]
@inline implicit def toinsOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[ins.tag.type]]
             
@inline implicit def tokbdApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[kbd.tag.type]]
@inline implicit def tokbdOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[kbd.tag.type]]
             
@inline implicit def tokeygenApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[keygen.tag.type]]
@inline implicit def tokeygenOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[keygen.tag.type]]
             
@inline implicit def tolabelApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[label.tag.type]]
@inline implicit def tolabelOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[label.tag.type]]
             
@inline implicit def tolegendApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[legend.tag.type]]
@inline implicit def tolegendOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[legend.tag.type]]
             
@inline implicit def toliApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[li.tag.type]]
@inline implicit def toliOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[li.tag.type]]
             
@inline implicit def tolinkApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[link.tag.type]]
@inline implicit def tolinkOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[link.tag.type]]
             
@inline implicit def tomainApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[main.tag.type]]
@inline implicit def tomainOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[main.tag.type]]
             
@inline implicit def tomapApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[map.tag.type]]
@inline implicit def tomapOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[map.tag.type]]
             
@inline implicit def tomarkApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[mark.tag.type]]
@inline implicit def tomarkOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[mark.tag.type]]
             
@inline implicit def tomenuApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[menu.tag.type]]
@inline implicit def tomenuOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[menu.tag.type]]
             
@inline implicit def tomenuitemApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[menuitem.tag.type]]
@inline implicit def tomenuitemOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[menuitem.tag.type]]
             
@inline implicit def tometaApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[meta.tag.type]]
@inline implicit def tometaOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[meta.tag.type]]
             
@inline implicit def tometerApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[meter.tag.type]]
@inline implicit def tometerOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[meter.tag.type]]
             
@inline implicit def tonavApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[nav.tag.type]]
@inline implicit def tonavOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[nav.tag.type]]
             
@inline implicit def tonoscriptApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[noscript.tag.type]]
@inline implicit def tonoscriptOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[noscript.tag.type]]
             
@inline implicit def toobjectApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[`object`.tag.type]]
@inline implicit def toobjectOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[`object`.tag.type]]
             
@inline implicit def toolApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[ol.tag.type]]
@inline implicit def toolOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[ol.tag.type]]
             
@inline implicit def tooptgroupApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[optgroup.tag.type]]
@inline implicit def tooptgroupOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[optgroup.tag.type]]
             
@inline implicit def tooptionApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[option.tag.type]]
@inline implicit def tooptionOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[option.tag.type]]
             
@inline implicit def tooutputApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[output.tag.type]]
@inline implicit def tooutputOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[output.tag.type]]
             
@inline implicit def topApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[p.tag.type]]
@inline implicit def topOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[p.tag.type]]
             
@inline implicit def toparamApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[param.tag.type]]
@inline implicit def toparamOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[param.tag.type]]
             
@inline implicit def topictureApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[picture.tag.type]]
@inline implicit def topictureOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[picture.tag.type]]
             
@inline implicit def topreApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[pre.tag.type]]
@inline implicit def topreOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[pre.tag.type]]
             
@inline implicit def toprogressApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[progress.tag.type]]
@inline implicit def toprogressOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[progress.tag.type]]
             
@inline implicit def toqApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[q.tag.type]]
@inline implicit def toqOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[q.tag.type]]
             
@inline implicit def torpApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[rp.tag.type]]
@inline implicit def torpOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[rp.tag.type]]
             
@inline implicit def tortApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[rt.tag.type]]
@inline implicit def tortOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[rt.tag.type]]
             
@inline implicit def torubyApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[ruby.tag.type]]
@inline implicit def torubyOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[ruby.tag.type]]
             
@inline implicit def tosApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[s.tag.type]]
@inline implicit def tosOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[s.tag.type]]
             
@inline implicit def tosampApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[samp.tag.type]]
@inline implicit def tosampOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[samp.tag.type]]
             
@inline implicit def toscriptApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[script.tag.type]]
@inline implicit def toscriptOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[script.tag.type]]
             
@inline implicit def tosectionApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[section.tag.type]]
@inline implicit def tosectionOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[section.tag.type]]
             
@inline implicit def toselectApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[select.tag.type]]
@inline implicit def toselectOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[select.tag.type]]
             
@inline implicit def tosmallApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[small.tag.type]]
@inline implicit def tosmallOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[small.tag.type]]
             
@inline implicit def tosourceApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[source.tag.type]]
@inline implicit def tosourceOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[source.tag.type]]
             
@inline implicit def tospanApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[span.tag.type]]
@inline implicit def tospanOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[span.tag.type]]
             
@inline implicit def tostrongApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[strong.tag.type]]
@inline implicit def tostrongOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[strong.tag.type]]
             
@inline implicit def tostyleApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[style.tag.type]]
@inline implicit def tostyleOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[style.tag.type]]
             
@inline implicit def tosubApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[sub.tag.type]]
@inline implicit def tosubOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[sub.tag.type]]
             
@inline implicit def tosummaryApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[summary.tag.type]]
@inline implicit def tosummaryOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[summary.tag.type]]
             
@inline implicit def tosupApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[sup.tag.type]]
@inline implicit def tosupOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[sup.tag.type]]
             
@inline implicit def totableApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[table.tag.type]]
@inline implicit def totableOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[table.tag.type]]
             
@inline implicit def totbodyApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[tbody.tag.type]]
@inline implicit def totbodyOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[tbody.tag.type]]
             
@inline implicit def totdApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[td.tag.type]]
@inline implicit def totdOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[td.tag.type]]
             
@inline implicit def totextareaApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[textarea.tag.type]]
@inline implicit def totextareaOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[textarea.tag.type]]
             
@inline implicit def totfootApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[tfoot.tag.type]]
@inline implicit def totfootOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[tfoot.tag.type]]
             
@inline implicit def tothApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[th.tag.type]]
@inline implicit def tothOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[th.tag.type]]
             
@inline implicit def totheadApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[thead.tag.type]]
@inline implicit def totheadOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[thead.tag.type]]
             
@inline implicit def totimeApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[time.tag.type]]
@inline implicit def totimeOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[time.tag.type]]
             
@inline implicit def totitleApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[title.tag.type]]
@inline implicit def totitleOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[title.tag.type]]
             
@inline implicit def totrApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[tr.tag.type]]
@inline implicit def totrOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[tr.tag.type]]
             
@inline implicit def totrackApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[track.tag.type]]
@inline implicit def totrackOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[track.tag.type]]
             
@inline implicit def touApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[u.tag.type]]
@inline implicit def touOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[u.tag.type]]
             
@inline implicit def toulApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[ul.tag.type]]
@inline implicit def toulOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[ul.tag.type]]
             
@inline implicit def tovarApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[`var`.tag.type]]
@inline implicit def tovarOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[`var`.tag.type]]
             
@inline implicit def tovideoApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[video.tag.type]]
@inline implicit def tovideoOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[video.tag.type]]
             
@inline implicit def towbrApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[wbr.tag.type]]
@inline implicit def towbrOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[wbr.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_data_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_data_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
