package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * The <strong>HTML <code>&lt;datalist&gt;</code> element</strong> contains a set of <a title="The HTML <option> element is used to define an item contained in a <select>, an <optgroup>, or a <datalist>&nbsp;element. As such,&nbsp;<option>&nbsp;can represent menu items in popups and other lists of items in an HTML document." href="/en-US/docs/Web/HTML/Element/option"><code>&lt;option&gt;</code></a> elements that represent the values available for other controls.
 */
object datalist extends Tag {
implicit object tag extends TagElement {
  type RefType = org.scalajs.dom.html.DataList
}
type tagType = tag.type

@inline def apply(mods: TagMod[tag.type]*): WithAttrs[tagType] = {
  WithAttrs("datalist", mods)
}


}

object _datalist_attr {

}
