package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * menuitem - This Boolean attribute indicates use of the same command as the menu's subject element (such as a <code>button</code> or <code>input</code>).
 * track - This attribute indicates that the track should be enabled unless the user's preferences indicate that another track is more appropriate. This may only be used on one <code>track</code> element per media element.
 */
object default extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: Boolean) = new AttrPair[_default_attr.type]("default", v)
@inline def :=(v: Option[Boolean]) = new OptionalAttrPair[_default_attr.type]("default", v)
type attrType = _default_attr.type
@inline implicit def boolToPairmenuitemApplied(attrObj: this.type) = new AttrPair[menuitem.tag.type]("default", true)
@inline implicit def boolToPairtrackApplied(attrObj: this.type) = new AttrPair[track.tag.type]("default", true)
@inline implicit def boolToPairstarApplied(attrObj: this.type) = new AttrPair[*.tag.type]("default", true)
}

object _default_attr {
@inline implicit def tomenuitemApplied(pair: AttrPair[_default_attr.type]) = pair.asInstanceOf[AttrPair[menuitem.tag.type]]
@inline implicit def tomenuitemOptionalApplied(pair: OptionalAttrPair[_default_attr.type]) = pair.asInstanceOf[OptionalAttrPair[menuitem.tag.type]]
             
@inline implicit def totrackApplied(pair: AttrPair[_default_attr.type]) = pair.asInstanceOf[AttrPair[track.tag.type]]
@inline implicit def totrackOptionalApplied(pair: OptionalAttrPair[_default_attr.type]) = pair.asInstanceOf[OptionalAttrPair[track.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_default_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_default_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
