package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * This Boolean attribute is set to indicate to a browser that the script is meant to be executed after the document has been parsed, but before firing&nbsp;<code><a title="/en-US/docs/Web/Events/DOMContentLoaded" href="/en-US/docs/Web/Events/DOMContentLoaded">DOMContentLoaded</a></code>. This attribute must not be used if the <code>src</code> attribute is absent (i.e. for inline scripts), in this case it would have no effect. To achieve a similar effect for dynamically inserted scripts use <code>async=false</code> instead. Scripts with the <code>defer</code> attribute will execute in the order in which they appear in the document.
 */
object defer extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: Boolean) = new AttrPair[_defer_attr.type]("defer", v)
@inline def :=(v: Option[Boolean]) = new OptionalAttrPair[_defer_attr.type]("defer", v)
type attrType = _defer_attr.type
@inline implicit def boolToPairscriptApplied(attrObj: this.type) = new AttrPair[script.tag.type]("defer", true)
@inline implicit def boolToPairstarApplied(attrObj: this.type) = new AttrPair[*.tag.type]("defer", true)
}

object _defer_attr {
@inline implicit def toscriptApplied(pair: AttrPair[_defer_attr.type]) = pair.asInstanceOf[AttrPair[script.tag.type]]
@inline implicit def toscriptOptionalApplied(pair: OptionalAttrPair[_defer_attr.type]) = pair.asInstanceOf[OptionalAttrPair[script.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_defer_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_defer_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
