package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * option - If this Boolean attribute is set, this option is not checkable. Often browsers grey out such control and it won't receive any browsing event, like mouse clicks or focus-related ones. If this attribute is not set, the element can still be disabled if one of its ancestors is a disabled <a title="The HTML <optgroup> element creates a grouping of options within a <select> element." href="/en-US/docs/Web/HTML/Element/optgroup"><code>&lt;optgroup&gt;</code></a> element.
 * textarea - This Boolean attribute indicates that the user cannot interact with the control. (If this attribute is not specified, the control inherits its setting from the containing element, for example <a title="The HTML <fieldset> element is used to group several controls as well as labels (<label>) within a web form." href="/en-US/docs/Web/HTML/Element/fieldset"><code>&lt;fieldset&gt;</code></a>; if there is no containing element with the <code>disabled</code> attribute set, then the control is enabled.)
 * menuitem - Boolean attribute which indicates that the command is not available in the current state. Note that <code>disabled</code> is distinct from <code>hidden</code>; the <code>disabled</code> attribute is appropriate in any context where a change in circumstances might render the command relevant.
 * link - This attribute is used to disable a link relationship. In conjunction with scripting, this attribute could be used to turn on and off various style sheet relationships. <div class="note">  <p><strong>Note: </strong>While there is no <code>disabled</code> attribute in the HTML standard, there <strong>is</strong> a <code>disabled</code> attribute on the <code>HTMLLinkElement</code> DOM object.</p>  <p>The use of <code>disabled</code> as an HTML attribute is non-standard and only used by some browsers (<a class="external" href="https://www.w3.org/Bugs/Public/show_bug.cgi?id=27677">W3 #27677</a>). <strong>Do not use it</strong>. To achieve a similar effect, use one of the following techniques:</p>  <ul>   <li>If the <code>disabled</code> attribute has been added directly to the element on the page, do not include the <a title="The HTML <link> element specifies relationships between the current document and an external resource. Possible uses for this element include defining a relational framework for navigation. This element is most used to link to style sheets." href="/en-US/docs/Web/HTML/Element/link"><code>&lt;link&gt;</code></a> element instead;</li>   <li>Set the <code>disabled</code> <strong>property</strong> of the <code>StyleSheet</code> DOM object via scripting.</li>  </ul> </div>
 * keygen - This Boolean attribute indicates that the form control is not available for interaction.
 * fieldset - If this Boolean attribute is set, the form controls that are its descendants, except descendants of its first optional <a href="/en-US/docs/Web/HTML/Element/legend" title="The HTML <legend> element represents a caption for the content of its parent <fieldset>."><code>&lt;legend&gt;</code></a> element, are disabled, i.e., not editable. They won't receive any browsing events, like mouse clicks or focus-related ones. Often browsers display such controls as gray.
 * optgroup - If this Boolean attribute is set, none of the items in this option group is selectable. Often browsers grey out such control and it won't receive any browsing events, like mouse clicks or focus-related ones.
 * select - This Boolean attribute indicates that the user cannot interact with the control. If this attribute is not specified, the control inherits its setting from the containing element, for example <code>fieldset</code>; if there is no containing element with the <code>disabled</code> attribute set, then the control is enabled.
 * input - <p>This Boolean attribute indicates that the form control is not available for interaction. In particular, the <code>click</code> event <a class="external" href="https://html.spec.whatwg.org/multipage/forms.html#enabling-and-disabling-form-controls:-the-disabled-attribute">will not be dispatched</a> on disabled controls. Also, a disabled control's value isn't submitted with the form.</p> <p>Unlike other browsers, Firefox will by default <a class="external" href="https://stackoverflow.com/questions/5985839/bug-with-firefox-disabled-attribute-of-input-not-resetting-when-refreshing">persist the dynamic disabled state</a> of an <code>&lt;input&gt;</code> across page loads. Use the <code><a href="/en-US/docs/Web/HTML/Element/input#attr-autocomplete">autocomplete</a></code> attribute to control this feature.</p>
 * button - <p>This Boolean attribute indicates that the user cannot interact with the button. If this attribute is not specified, the button inherits its setting from the containing element, for example <a title="The HTML <fieldset> element is used to group several controls as well as labels (<label>) within a web form." href="/en-US/docs/Web/HTML/Element/fieldset"><code>&lt;fieldset&gt;</code></a>; if there is no containing element with the <strong>disabled</strong> attribute set, then the button is enabled.</p> <p>Firefox will, unlike other browsers, by default, <a class="external" href="https://stackoverflow.com/questions/5985839/bug-with-firefox-disabled-attribute-of-input-not-resetting-when-refreshing">persist the dynamic disabled state</a> of a <a title="The HTML <button> element represents a clickable button." href="/en-US/docs/Web/HTML/Element/button"><code>&lt;button&gt;</code></a> across page loads. Use the <code><a href="/en-US/docs/Web/HTML/Element/button#attr-autocomplete">autocomplete</a></code> attribute to control this feature.</p>
 */
object disabled extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: Boolean) = new AttrPair[_disabled_attr.type]("disabled", v)
@inline def :=(v: Option[Boolean]) = new OptionalAttrPair[_disabled_attr.type]("disabled", v)
type attrType = _disabled_attr.type
@inline implicit def boolToPairbuttonApplied(attrObj: this.type) = new AttrPair[button.tag.type]("disabled", true)
@inline implicit def boolToPairfieldsetApplied(attrObj: this.type) = new AttrPair[fieldset.tag.type]("disabled", true)
@inline implicit def boolToPairinputApplied(attrObj: this.type) = new AttrPair[input.tag.type]("disabled", true)
@inline implicit def boolToPairkeygenApplied(attrObj: this.type) = new AttrPair[keygen.tag.type]("disabled", true)
@inline implicit def boolToPairlinkApplied(attrObj: this.type) = new AttrPair[link.tag.type]("disabled", true)
@inline implicit def boolToPairmenuitemApplied(attrObj: this.type) = new AttrPair[menuitem.tag.type]("disabled", true)
@inline implicit def boolToPairoptgroupApplied(attrObj: this.type) = new AttrPair[optgroup.tag.type]("disabled", true)
@inline implicit def boolToPairoptionApplied(attrObj: this.type) = new AttrPair[option.tag.type]("disabled", true)
@inline implicit def boolToPairselectApplied(attrObj: this.type) = new AttrPair[select.tag.type]("disabled", true)
@inline implicit def boolToPairtextareaApplied(attrObj: this.type) = new AttrPair[textarea.tag.type]("disabled", true)
@inline implicit def boolToPairstarApplied(attrObj: this.type) = new AttrPair[*.tag.type]("disabled", true)
}

object _disabled_attr {
@inline implicit def tobuttonApplied(pair: AttrPair[_disabled_attr.type]) = pair.asInstanceOf[AttrPair[button.tag.type]]
@inline implicit def tobuttonOptionalApplied(pair: OptionalAttrPair[_disabled_attr.type]) = pair.asInstanceOf[OptionalAttrPair[button.tag.type]]
             
@inline implicit def tofieldsetApplied(pair: AttrPair[_disabled_attr.type]) = pair.asInstanceOf[AttrPair[fieldset.tag.type]]
@inline implicit def tofieldsetOptionalApplied(pair: OptionalAttrPair[_disabled_attr.type]) = pair.asInstanceOf[OptionalAttrPair[fieldset.tag.type]]
             
@inline implicit def toinputApplied(pair: AttrPair[_disabled_attr.type]) = pair.asInstanceOf[AttrPair[input.tag.type]]
@inline implicit def toinputOptionalApplied(pair: OptionalAttrPair[_disabled_attr.type]) = pair.asInstanceOf[OptionalAttrPair[input.tag.type]]
             
@inline implicit def tokeygenApplied(pair: AttrPair[_disabled_attr.type]) = pair.asInstanceOf[AttrPair[keygen.tag.type]]
@inline implicit def tokeygenOptionalApplied(pair: OptionalAttrPair[_disabled_attr.type]) = pair.asInstanceOf[OptionalAttrPair[keygen.tag.type]]
             
@inline implicit def tolinkApplied(pair: AttrPair[_disabled_attr.type]) = pair.asInstanceOf[AttrPair[link.tag.type]]
@inline implicit def tolinkOptionalApplied(pair: OptionalAttrPair[_disabled_attr.type]) = pair.asInstanceOf[OptionalAttrPair[link.tag.type]]
             
@inline implicit def tomenuitemApplied(pair: AttrPair[_disabled_attr.type]) = pair.asInstanceOf[AttrPair[menuitem.tag.type]]
@inline implicit def tomenuitemOptionalApplied(pair: OptionalAttrPair[_disabled_attr.type]) = pair.asInstanceOf[OptionalAttrPair[menuitem.tag.type]]
             
@inline implicit def tooptgroupApplied(pair: AttrPair[_disabled_attr.type]) = pair.asInstanceOf[AttrPair[optgroup.tag.type]]
@inline implicit def tooptgroupOptionalApplied(pair: OptionalAttrPair[_disabled_attr.type]) = pair.asInstanceOf[OptionalAttrPair[optgroup.tag.type]]
             
@inline implicit def tooptionApplied(pair: AttrPair[_disabled_attr.type]) = pair.asInstanceOf[AttrPair[option.tag.type]]
@inline implicit def tooptionOptionalApplied(pair: OptionalAttrPair[_disabled_attr.type]) = pair.asInstanceOf[OptionalAttrPair[option.tag.type]]
             
@inline implicit def toselectApplied(pair: AttrPair[_disabled_attr.type]) = pair.asInstanceOf[AttrPair[select.tag.type]]
@inline implicit def toselectOptionalApplied(pair: OptionalAttrPair[_disabled_attr.type]) = pair.asInstanceOf[OptionalAttrPair[select.tag.type]]
             
@inline implicit def totextareaApplied(pair: AttrPair[_disabled_attr.type]) = pair.asInstanceOf[AttrPair[textarea.tag.type]]
@inline implicit def totextareaOptionalApplied(pair: OptionalAttrPair[_disabled_attr.type]) = pair.asInstanceOf[OptionalAttrPair[textarea.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_disabled_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_disabled_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
