package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * The <strong>HTML <code>&lt;div&gt;</code> element</strong> is the generic container for flow content and does not inherently represent anything. Use it to group elements for purposes such as styling (using the <code><a href="/en-US/docs/Web/HTML/Global_attributes#attr-class">class</a></code> or <code><a href="/en-US/docs/Web/HTML/Global_attributes#attr-id">id</a></code> attributes), marking a section of a document in a different language (using the <code><a href="/en-US/docs/Web/HTML/Global_attributes#attr-lang">lang</a></code> attribute), and so on.
 */
object div extends Tag {
implicit object tag extends TagElement {
  type RefType = org.scalajs.dom.html.Div
}
type tagType = tag.type

@inline def apply(mods: TagMod[tag.type]*): WithAttrs[tagType] = {
  WithAttrs("div", mods)
}


}

object _div_attr {

}
