package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * area - This attribute, if present, indicates that the author intends the hyperlink to be used for downloading a resource. See <a title="The HTML <a> element (or anchor element) creates a hyperlink to other web pages, files, locations within the same page, email addresses, or any other URL." href="/en-US/docs/Web/HTML/Element/a"><code>&lt;a&gt;</code></a> for a full description of the <code><a href="/en-US/docs/Web/HTML/Element/a#attr-download">download</a></code> attribute.
 * a - This attribute instructs browsers to download a URL instead of navigating to it, so the user will be prompted to save it as a local file. If the attribute has a value, it is used as the pre-filled file name in the Save prompt (the user can still change the file name if they want). There are no restrictions on allowed values, though <code>/</code> and <code>\</code> are converted to underscores. Most file systems limit some punctuation in file names, and browsers will adjust the suggested name accordingly. <div class="note"> <strong>Notes:</strong>  <ul>   <li>This attribute only works for <a href="/en-US/docs/Web/Security/Same-origin_policy">same-origin URLs</a>.</li>   <li>This attribute can be used with <a href="/en-US/docs/Web/API/URL.createObjectURL"><code>blob:</code> URLs</a> and <a href="/en-US/docs/Web/HTTP/Basics_of_HTTP/Data_URIs"><code>data:</code> URLs</a> to download content generated by JavaScript, such as pictures created in an image-editor Web app.</li>   <li>If the HTTP header <a href="/en-US/docs/Web/HTTP/Headers/Content-Disposition"><code>Content-Disposition:</code></a> gives a different filename than this attribute, the HTTP header takes priority over this attribute.</li>   <li>If <code>Content-Disposition:</code> is set to <code>inline</code>, Firefox prioritizes <code>Content-Disposition</code>, like the filename case, while Chrome prioritizes the <code>download</code> attribute.</li>  </ul> </div>
 */
object download extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: Boolean) = new AttrPair[_download_attr.type]("download", v)
@inline def :=(v: Option[Boolean]) = new OptionalAttrPair[_download_attr.type]("download", v)
type attrType = _download_attr.type
@inline implicit def boolToPairaApplied(attrObj: this.type) = new AttrPair[a.tag.type]("download", true)
@inline implicit def boolToPairareaApplied(attrObj: this.type) = new AttrPair[area.tag.type]("download", true)
@inline implicit def boolToPairstarApplied(attrObj: this.type) = new AttrPair[*.tag.type]("download", true)
}

object _download_attr {
@inline implicit def toaApplied(pair: AttrPair[_download_attr.type]) = pair.asInstanceOf[AttrPair[a.tag.type]]
@inline implicit def toaOptionalApplied(pair: OptionalAttrPair[_download_attr.type]) = pair.asInstanceOf[OptionalAttrPair[a.tag.type]]
             
@inline implicit def toareaApplied(pair: AttrPair[_download_attr.type]) = pair.asInstanceOf[AttrPair[area.tag.type]]
@inline implicit def toareaOptionalApplied(pair: OptionalAttrPair[_download_attr.type]) = pair.asInstanceOf[OptionalAttrPair[area.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_download_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_download_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
