package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * The <strong>HTML <code>&lt;dt&gt;</code> element</strong> identifies a term in a description list. This element can occur only as a child element of a <a title="The HTML <dl>&nbsp;element represents a description list.&nbsp;The element encloses a list of groups of terms and descriptions. Common uses for this element are to implement a glossary or to display metadata (a list of key-value pairs)." href="/en-US/docs/Web/HTML/Element/dl"><code>&lt;dl&gt;</code></a>. It is usually followed by a <a title="The&nbsp;HTML <dd> element indicates the description of a term in a description list (<dl>)." href="/en-US/docs/Web/HTML/Element/dd"><code>&lt;dd&gt;</code></a> element; however, multiple <code>&lt;dt&gt;</code> elements in a row indicate several terms that are all defined by the immediate next <a title="The&nbsp;HTML <dd> element indicates the description of a term in a description list (<dl>)." href="/en-US/docs/Web/HTML/Element/dd"><code>&lt;dd&gt;</code></a> element.
 */
object dt extends Tag {
implicit object tag extends TagElement {
  type RefType = org.scalajs.dom.html.DT
}
type tagType = tag.type

@inline def apply(mods: TagMod[tag.type]*): WithAttrs[tagType] = {
  WithAttrs("dt", mods)
}


}

object _dt_attr {

}
