package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * The <strong>HTML <code>&lt;embed&gt;</code> element</strong> represents an integration point for an external application or interactive content (in other words, a plug-in).
 */
object embed extends Tag {
implicit object tag extends TagElement {
  type RefType = org.scalajs.dom.html.Embed
}
type tagType = tag.type

@inline def apply(mods: TagMod[tag.type]*): WithAttrs[tagType] = {
  WithAttrs("embed", mods)
}


}

object _embed_attr {

}
