package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * The <strong>HTML <code>&lt;figcaption&gt;</code> element</strong> represents a caption or a legend associated with a figure or an illustration described by the rest of the data of the <a title="The HTML <figure> element represents self-contained content, frequently with a caption (<figcaption>), and is typically referenced as a single unit." href="/en-US/docs/Web/HTML/Element/figure"><code>&lt;figure&gt;</code></a> element which is its immediate ancestor.
 */
object figcaption extends Tag {
implicit object tag extends TagElement {
  type RefType = org.scalajs.dom.html.Element
}
type tagType = tag.type

@inline def apply(mods: TagMod[tag.type]*): WithAttrs[tagType] = {
  WithAttrs("figcaption", mods)
}


}

object _figcaption_attr {

}
