package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * The <strong>HTML <code>&lt;form&gt;</code> element</strong> represents a document section that contains interactive controls to submit information to a web server.
 * select - This attribute lets you specify the form element to&nbsp;which&nbsp;the select element is associated&nbsp;(that is, its "form owner"). If this attribute is specified, its value must be the ID of a form element in the same document. This enables you to place select elements anywhere within a document, not just as descendants of their form elements.
 * object - The form element, if any, that the object element is associated with (its <em>form owner</em>). The value of the attribute must be an ID of a <a title="The HTML <form> element represents a document section that contains interactive controls to submit information to a web server." href="/en-US/docs/Web/HTML/Element/form"><code>&lt;form&gt;</code></a> element in the same document.
 * input - The form element that the input element is associated with (its <em>form owner</em>). The value of the attribute must be an <strong>id</strong> of a <a title="The HTML <form> element represents a document section that contains interactive controls to submit information to a web server." href="/en-US/docs/Web/HTML/Element/form"><code>&lt;form&gt;</code></a> element in the same document. If this attribute is not specified, this <code>&lt;input&gt;</code> element must be a descendant of a <a title="The HTML <form> element represents a document section that contains interactive controls to submit information to a web server." href="/en-US/docs/Web/HTML/Element/form"><code>&lt;form&gt;</code></a> element. This attribute enables you to place <code>&lt;input&gt;</code> elements anywhere within a document, not just as descendants of their form elements. An input can only be associated with one form.
 * button - The form element that the button is associated with (its <em>form owner</em>). The value of the attribute must be the <strong>id</strong> attribute of a <a title="The HTML <form> element represents a document section that contains interactive controls to submit information to a web server." href="/en-US/docs/Web/HTML/Element/form"><code>&lt;form&gt;</code></a> element in the same document. If this attribute is not specified, the <code>&lt;button&gt;</code> element will&nbsp;be associated to an&nbsp;ancestor <a title="The HTML <form> element represents a document section that contains interactive controls to submit information to a web server." href="/en-US/docs/Web/HTML/Element/form"><code>&lt;form&gt;</code></a>&nbsp;element, if one exists. This attribute enables you to associate&nbsp;<code>&lt;button&gt;</code> elements to&nbsp;<a title="The HTML <form> element represents a document section that contains interactive controls to submit information to a web server." href="/en-US/docs/Web/HTML/Element/form"><code>&lt;form&gt;</code></a>&nbsp;elements anywhere&nbsp;within a document, not just as descendants of <a title="The HTML <form> element represents a document section that contains interactive controls to submit information to a web server." href="/en-US/docs/Web/HTML/Element/form"><code>&lt;form&gt;</code></a> elements.
 * output - The form element that this element is associated with (its "form owner"). The value of the attribute must be an ID of a form element in the same document. If this attribute is not specified, the output element must be a descendant of a form element. This attribute enables you to place output elements anywhere within a document, not just as descendants of their form elements.
 * label - The form element with which the label is associated (its <em>form owner</em>). If specified, the value of the attribute is the ID of a <a title="The HTML <form> element represents a document section that contains interactive controls to submit information to a web server." href="/en-US/docs/Web/HTML/Element/form"><code>&lt;form&gt;</code></a> element in the same document. This lets you place label elements anywhere within a document, not just as descendants of their form elements.<br> &nbsp; <div class="note"> This content attribute was  <a class="external" href="https://github.com/whatwg/html/pull/1120">removed from the HTML specification</a> on April 28, 2016. However, scripts still have access to a read-only  <a title="The read-only HTMLLabelElement.form property returns an HTMLFormElement object which represents the form of which the label's associated control is a part, or null if there is either no associated control, or if that control isn't in a form." href="/en-US/docs/Web/API/HTMLLabelElement/form"><code>HTMLLabelElement.form</code></a> attribute; it returns the form of which the label's associated control is a member, or  <code>null</code> if the label is not associated with a control or the control isn't part of a form.</div>
 * textarea - The form element that the <code>&lt;textarea&gt;</code> element is associated with (its "form owner"). The value of the attribute must be the ID of a form element in the same document. If this attribute is not specified, the <code>&lt;textarea&gt;</code> element must be a descendant of a form element. This attribute enables you to place <code>&lt;textarea&gt;</code> elements anywhere within a document, not just as descendants of their form elements.
 * keygen - The form element that this element is associated with (its <em>form owner</em>). The value of the attribute must be an <code>id</code> of a <a title="The HTML <form> element represents a document section that contains interactive controls to submit information to a web server." href="/en-US/docs/Web/HTML/Element/form"><code>&lt;form&gt;</code></a> element in the same document. If this attribute is not specified, this element must be a descendant of a <a title="The HTML <form> element represents a document section that contains interactive controls to submit information to a web server." href="/en-US/docs/Web/HTML/Element/form"><code>&lt;form&gt;</code></a> element. This attribute enables you to place <code>&lt;keygen&gt; </code>elements anywhere within a document, not just as descendants of their form elements.
 * meter - This attribute associates the element with a <code>form</code> element that has ownership of the <code>meter</code> element. For example, a <code>meter</code> might be displaying a range corresponding to an <code>input</code> element of <code>type</code> <em>number</em>. This attribute is only used if the <code>meter</code> element is being used as a form-associated element; even then, it may be omitted if the element appears as a descendant of a <code>form</code> element.
 * fieldset - This attribute has the value of the <strong>id </strong>attribute of the <a href="/en-US/docs/Web/HTML/Element/form" title="The HTML <form> element represents a document section that contains interactive controls to submit information to a web server."><code>&lt;form&gt;</code></a> element it's related to. Its default value is the <strong>id</strong> of the nearest <a href="/en-US/docs/Web/HTML/Element/form" title="The HTML <form> element represents a document section that contains interactive controls to submit information to a web server."><code>&lt;form&gt;</code></a> element it is a descendant of.
 */
object form extends Tag with Attr {
implicit object tag extends TagElement {
  type RefType = org.scalajs.dom.html.Form
}
type tagType = tag.type

@inline def apply(mods: TagMod[tag.type]*): WithAttrs[tagType] = {
  WithAttrs("form", mods)
}
@inline def :=(v: String) = new AttrPair[_form_attr.type]("form", v)
@inline def :=(v: Option[String]) = new OptionalAttrPair[_form_attr.type]("form", v)
type attrType = _form_attr.type

}

object _form_attr {
@inline implicit def tobuttonApplied(pair: AttrPair[_form_attr.type]) = pair.asInstanceOf[AttrPair[button.tag.type]]
@inline implicit def tobuttonOptionalApplied(pair: OptionalAttrPair[_form_attr.type]) = pair.asInstanceOf[OptionalAttrPair[button.tag.type]]
             
@inline implicit def tofieldsetApplied(pair: AttrPair[_form_attr.type]) = pair.asInstanceOf[AttrPair[fieldset.tag.type]]
@inline implicit def tofieldsetOptionalApplied(pair: OptionalAttrPair[_form_attr.type]) = pair.asInstanceOf[OptionalAttrPair[fieldset.tag.type]]
             
@inline implicit def toinputApplied(pair: AttrPair[_form_attr.type]) = pair.asInstanceOf[AttrPair[input.tag.type]]
@inline implicit def toinputOptionalApplied(pair: OptionalAttrPair[_form_attr.type]) = pair.asInstanceOf[OptionalAttrPair[input.tag.type]]
             
@inline implicit def tokeygenApplied(pair: AttrPair[_form_attr.type]) = pair.asInstanceOf[AttrPair[keygen.tag.type]]
@inline implicit def tokeygenOptionalApplied(pair: OptionalAttrPair[_form_attr.type]) = pair.asInstanceOf[OptionalAttrPair[keygen.tag.type]]
             
@inline implicit def tolabelApplied(pair: AttrPair[_form_attr.type]) = pair.asInstanceOf[AttrPair[label.tag.type]]
@inline implicit def tolabelOptionalApplied(pair: OptionalAttrPair[_form_attr.type]) = pair.asInstanceOf[OptionalAttrPair[label.tag.type]]
             
@inline implicit def tometerApplied(pair: AttrPair[_form_attr.type]) = pair.asInstanceOf[AttrPair[meter.tag.type]]
@inline implicit def tometerOptionalApplied(pair: OptionalAttrPair[_form_attr.type]) = pair.asInstanceOf[OptionalAttrPair[meter.tag.type]]
             
@inline implicit def toobjectApplied(pair: AttrPair[_form_attr.type]) = pair.asInstanceOf[AttrPair[`object`.tag.type]]
@inline implicit def toobjectOptionalApplied(pair: OptionalAttrPair[_form_attr.type]) = pair.asInstanceOf[OptionalAttrPair[`object`.tag.type]]
             
@inline implicit def tooutputApplied(pair: AttrPair[_form_attr.type]) = pair.asInstanceOf[AttrPair[output.tag.type]]
@inline implicit def tooutputOptionalApplied(pair: OptionalAttrPair[_form_attr.type]) = pair.asInstanceOf[OptionalAttrPair[output.tag.type]]
             
@inline implicit def toselectApplied(pair: AttrPair[_form_attr.type]) = pair.asInstanceOf[AttrPair[select.tag.type]]
@inline implicit def toselectOptionalApplied(pair: OptionalAttrPair[_form_attr.type]) = pair.asInstanceOf[OptionalAttrPair[select.tag.type]]
             
@inline implicit def totextareaApplied(pair: AttrPair[_form_attr.type]) = pair.asInstanceOf[AttrPair[textarea.tag.type]]
@inline implicit def totextareaOptionalApplied(pair: OptionalAttrPair[_form_attr.type]) = pair.asInstanceOf[OptionalAttrPair[textarea.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_form_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_form_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
