package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * The <strong>HTML <code>&lt;head&gt;</code> element</strong> provides general information (metadata) about the document, including its title and links to its&nbsp;scripts and style sheets.
 */
object head extends Tag {
implicit object tag extends TagElement {
  type RefType = org.scalajs.dom.html.Head
}
type tagType = tag.type

@inline def apply(mods: TagMod[tag.type]*): WithAttrs[tagType] = {
  WithAttrs("head", mods)
}


}

object _head_attr {

}
