package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * th - This attribute contains&nbsp;a list of space-separated strings, each corresponding to the <code>id</code> attributes of other <a title="The HTML <th> element defines a cell as header of a group of table cells. The exact nature of this group is defined by the scope and headers attributes." href="/en-US/docs/Web/HTML/Element/th"><code>&lt;th&gt;</code></a> elements that relate to this element.
 * td - This attribute contains a list of space-separated strings, each corresponding to the <strong>id</strong> attribute of the <a title="The HTML <th> element defines a cell as header of a group of table cells. The exact nature of this group is defined by the scope and headers attributes." href="/en-US/docs/Web/HTML/Element/th"><code>&lt;th&gt;</code></a> elements that apply to this element.
 */
object headers extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: String) = new AttrPair[_headers_attr.type]("headers", v)
@inline def :=(v: Option[String]) = new OptionalAttrPair[_headers_attr.type]("headers", v)
type attrType = _headers_attr.type

}

object _headers_attr {
@inline implicit def totdApplied(pair: AttrPair[_headers_attr.type]) = pair.asInstanceOf[AttrPair[td.tag.type]]
@inline implicit def totdOptionalApplied(pair: OptionalAttrPair[_headers_attr.type]) = pair.asInstanceOf[OptionalAttrPair[td.tag.type]]
             
@inline implicit def tothApplied(pair: AttrPair[_headers_attr.type]) = pair.asInstanceOf[AttrPair[th.tag.type]]
@inline implicit def tothOptionalApplied(pair: OptionalAttrPair[_headers_attr.type]) = pair.asInstanceOf[OptionalAttrPair[th.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_headers_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_headers_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
