package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * img - The intrinsic height of the image in&nbsp;pixels.&nbsp;In <span class="inlineIndicator htmlVer htmlVerInline"><a href="/en-US/docs/HTML">HTML 4</a></span>, the height could be defined&nbsp;pixels or as a percentage. In&nbsp;<span class="inlineIndicator htmlVer htmlVerInline"><a href="/en-US/docs/HTML/HTML5">HTML5</a></span>, however, the value must be in pixels.
 * embed - The displayed height of the resource, in <a class="external" href="https://drafts.csswg.org/css-values/#px">CSS pixels</a>. &nbsp;-- (Absolute values&nbsp;only. &nbsp;<a class="external" href="https://html.spec.whatwg.org/multipage/embedded-content.html#dimension-attributes">NO&nbsp;percentages</a>)
 * canvas - The height of the coordinate space in CSS pixels. Defaults to 150.
 * input - If the value of the <strong>type</strong> attribute is <code>image</code>, this attribute defines the height of the image displayed for the button.
 * iframe - Indicates the height of the frame <span class="inlineIndicator htmlVer htmlVerInline"><a href="/en-US/docs/HTML/HTML5">HTML5</a></span> in CSS pixels, or <span class="inlineIndicator htmlVer htmlVerInline">HTML 4.01</span> in pixels or as a percentage.
 * video - The height of the video's display area, in&nbsp;<a class="external" href="https://drafts.csswg.org/css-values/#px">CSS pixels</a>. &nbsp;-- (Absolute values&nbsp;only. &nbsp;<a class="external" href="https://html.spec.whatwg.org/multipage/embedded-content.html#dimension-attributes">NO&nbsp;percentages</a>)
 * object - The height of the displayed resource, in <a class="external" href="https://drafts.csswg.org/css-values/#px">CSS pixels</a>. &nbsp;-- (Absolute values&nbsp;only. &nbsp;<a class="external" href="https://html.spec.whatwg.org/multipage/embedded-content.html#dimension-attributes">NO&nbsp;percentages</a>)
 */
object height extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: String) = new AttrPair[_height_attr.type]("height", v)
@inline def :=(v: Option[String]) = new OptionalAttrPair[_height_attr.type]("height", v)
type attrType = _height_attr.type

}

object _height_attr {
@inline implicit def tocanvasApplied(pair: AttrPair[_height_attr.type]) = pair.asInstanceOf[AttrPair[canvas.tag.type]]
@inline implicit def tocanvasOptionalApplied(pair: OptionalAttrPair[_height_attr.type]) = pair.asInstanceOf[OptionalAttrPair[canvas.tag.type]]
             
@inline implicit def toembedApplied(pair: AttrPair[_height_attr.type]) = pair.asInstanceOf[AttrPair[embed.tag.type]]
@inline implicit def toembedOptionalApplied(pair: OptionalAttrPair[_height_attr.type]) = pair.asInstanceOf[OptionalAttrPair[embed.tag.type]]
             
@inline implicit def toiframeApplied(pair: AttrPair[_height_attr.type]) = pair.asInstanceOf[AttrPair[iframe.tag.type]]
@inline implicit def toiframeOptionalApplied(pair: OptionalAttrPair[_height_attr.type]) = pair.asInstanceOf[OptionalAttrPair[iframe.tag.type]]
             
@inline implicit def toimgApplied(pair: AttrPair[_height_attr.type]) = pair.asInstanceOf[AttrPair[img.tag.type]]
@inline implicit def toimgOptionalApplied(pair: OptionalAttrPair[_height_attr.type]) = pair.asInstanceOf[OptionalAttrPair[img.tag.type]]
             
@inline implicit def toinputApplied(pair: AttrPair[_height_attr.type]) = pair.asInstanceOf[AttrPair[input.tag.type]]
@inline implicit def toinputOptionalApplied(pair: OptionalAttrPair[_height_attr.type]) = pair.asInstanceOf[OptionalAttrPair[input.tag.type]]
             
@inline implicit def toobjectApplied(pair: AttrPair[_height_attr.type]) = pair.asInstanceOf[AttrPair[`object`.tag.type]]
@inline implicit def toobjectOptionalApplied(pair: OptionalAttrPair[_height_attr.type]) = pair.asInstanceOf[OptionalAttrPair[`object`.tag.type]]
             
@inline implicit def tovideoApplied(pair: AttrPair[_height_attr.type]) = pair.asInstanceOf[AttrPair[video.tag.type]]
@inline implicit def tovideoOptionalApplied(pair: OptionalAttrPair[_height_attr.type]) = pair.asInstanceOf[OptionalAttrPair[video.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_height_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_height_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
