package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * The lower numeric bound of the high end of the measured range. This must be less than the maximum value (<code>max</code> attribute), and it also must be greater than the low value and minimum value (<code>low</code> attribute and <strong>min</strong> attribute, respectively), if any are specified. If unspecified, or if greater than the maximum value, the <code>high</code> value is equal to the maximum value.
 */
object high extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: String) = new AttrPair[_high_attr.type]("high", v)
@inline def :=(v: Option[String]) = new OptionalAttrPair[_high_attr.type]("high", v)
type attrType = _high_attr.type

}

object _high_attr {
@inline implicit def tometerApplied(pair: AttrPair[_high_attr.type]) = pair.asInstanceOf[AttrPair[meter.tag.type]]
@inline implicit def tometerOptionalApplied(pair: OptionalAttrPair[_high_attr.type]) = pair.asInstanceOf[OptionalAttrPair[meter.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_high_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_high_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
