package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * a - Contains a URL or a URL fragment that the hyperlink points to. A URL fragment is a name preceded by a hash mark (<code>#</code>), which specifies an internal target location (an <a href="/en-US/docs/HTML/Global_attributes#attr-id">ID</a> of an HTML element) within the current document. URLs are not restricted to Web (HTTP)-based documents, but can use any protocol supported by the browser. For example, <a class="external" href="https://en.wikipedia.org/wiki/File_URI_scheme"><code>file:</code></a>, <code>ftp:</code>, and <code>mailto:</code> work in most browsers. This attribute may be omitted (as of HTML5) to create a placeholder link. A placeholder link resembles a traditional hyperlink, but does not lead anywhere. <div class="note">  <p><strong>Note:</strong> You can use <code>href="#top"</code> or the empty fragment <code>href="#"</code> to link to the top of the current page. <a class="external" href="https://www.w3.org/TR/html5/single-page.html#scroll-to-fragid">This behavior is specified by HTML5</a>.</p> </div>
 * area - The hyperlink target for the area. Its value is a valid URL. In HTML4, either this attribute or the <strong>nohref</strong> attribute must be present in the element. In HTML5, this attribute may be omitted; if so, the area element does not represent a hyperlink.
 * link - This attribute specifies the <a title="URL: Uniform Resource Locator (URL) is a text string specifying where a resource can be found on the Internet." class="glossaryLink" href="/en-US/docs/Glossary/URL">URL</a> of the linked resource. A URL might be absolute or relative.
 * base - The base URL to be used throughout the document for relative URL addresses. If this attribute is specified, this element must come before any other elements with attributes whose values are URLs. Absolute and relative URLs are allowed.
 */
object href extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: String) = new AttrPair[_href_attr.type]("href", v)
@inline def :=(v: Option[String]) = new OptionalAttrPair[_href_attr.type]("href", v)
type attrType = _href_attr.type

}

object _href_attr {
@inline implicit def toaApplied(pair: AttrPair[_href_attr.type]) = pair.asInstanceOf[AttrPair[a.tag.type]]
@inline implicit def toaOptionalApplied(pair: OptionalAttrPair[_href_attr.type]) = pair.asInstanceOf[OptionalAttrPair[a.tag.type]]
             
@inline implicit def toareaApplied(pair: AttrPair[_href_attr.type]) = pair.asInstanceOf[AttrPair[area.tag.type]]
@inline implicit def toareaOptionalApplied(pair: OptionalAttrPair[_href_attr.type]) = pair.asInstanceOf[OptionalAttrPair[area.tag.type]]
             
@inline implicit def tobaseApplied(pair: AttrPair[_href_attr.type]) = pair.asInstanceOf[AttrPair[base.tag.type]]
@inline implicit def tobaseOptionalApplied(pair: OptionalAttrPair[_href_attr.type]) = pair.asInstanceOf[OptionalAttrPair[base.tag.type]]
             
@inline implicit def tolinkApplied(pair: AttrPair[_href_attr.type]) = pair.asInstanceOf[AttrPair[link.tag.type]]
@inline implicit def tolinkOptionalApplied(pair: OptionalAttrPair[_href_attr.type]) = pair.asInstanceOf[OptionalAttrPair[link.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_href_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_href_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
