package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * label - The ID of a <a href="/en-US/docs/Web/Guide/HTML/Content_categories#Form_labelable">labelable</a> form-related element in the same document as the label element. The first such element in the document with an ID matching the value of the <code>for</code> attribute is the <em>labeled control </em>for this label element.<br> &nbsp; <div class="note"> A label element can have both a  <code>for</code> attribute and a contained control element, as long as the  <code>for</code> attribute points to the contained control element.</div>
 * output - A list of IDs of other elements, indicating that those elements contributed input values to (or otherwise affected) the calculation.
 */
object htmlFor extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: String) = new AttrPair[_htmlFor_attr.type]("htmlFor", v)
@inline def :=(v: Option[String]) = new OptionalAttrPair[_htmlFor_attr.type]("htmlFor", v)
type attrType = _htmlFor_attr.type

}

object _htmlFor_attr {
@inline implicit def tolabelApplied(pair: AttrPair[_htmlFor_attr.type]) = pair.asInstanceOf[AttrPair[label.tag.type]]
@inline implicit def tolabelOptionalApplied(pair: OptionalAttrPair[_htmlFor_attr.type]) = pair.asInstanceOf[OptionalAttrPair[label.tag.type]]
             
@inline implicit def tooutputApplied(pair: AttrPair[_htmlFor_attr.type]) = pair.asInstanceOf[AttrPair[output.tag.type]]
@inline implicit def tooutputOptionalApplied(pair: OptionalAttrPair[_htmlFor_attr.type]) = pair.asInstanceOf[OptionalAttrPair[output.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_htmlFor_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_htmlFor_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
