package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * script - Contains inline metadata that a user agent can use to verify that a fetched resource has been delivered free of unexpected manipulation. See <a href="/en-US/docs/Web/Security/Subresource_Integrity">Subresource Integrity</a>.
 * link - Contains inline metadata, a base64-encoded&nbsp;cryptographic hash of a resource (file) you’re telling the browser to fetch,&nbsp;that a user agent can use to verify that a fetched resource has been delivered free of unexpected manipulation. See <a href="/en-US/docs/Web/Security/Subresource_Integrity">Subresource Integrity</a>.
 */
object integrity extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: String) = new AttrPair[_integrity_attr.type]("integrity", v)
@inline def :=(v: Option[String]) = new OptionalAttrPair[_integrity_attr.type]("integrity", v)
type attrType = _integrity_attr.type

}

object _integrity_attr {
@inline implicit def tolinkApplied(pair: AttrPair[_integrity_attr.type]) = pair.asInstanceOf[AttrPair[link.tag.type]]
@inline implicit def tolinkOptionalApplied(pair: OptionalAttrPair[_integrity_attr.type]) = pair.asInstanceOf[OptionalAttrPair[link.tag.type]]
             
@inline implicit def toscriptApplied(pair: AttrPair[_integrity_attr.type]) = pair.asInstanceOf[AttrPair[script.tag.type]]
@inline implicit def toscriptOptionalApplied(pair: OptionalAttrPair[_integrity_attr.type]) = pair.asInstanceOf[OptionalAttrPair[script.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_integrity_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_integrity_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
