package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * How the text track is meant to be used. If omitted the default kind is <code>subtitles</code>. If the attribute is not present, it will use the <code>subtitles</code>. If the attribute contains an invalid value, it will use <code>metadata</code>. (Versions of Chrome earlier than 52 treated an invalid value as <code>subtitles</code>.)&nbsp;The following keywords are allowed: <ul>  <li><code>subtitles</code>   <ul>    <li>Subtitles provide translation of content that cannot be understood by the viewer. For example dialogue or text that is not English in an English language film.</li>    <li>Subtitles may contain additional content, usually extra background information. For example the text at the beginning of the Star Wars films, or the date, time, and location of a scene.</li>   </ul> </li>  <li><code>captions</code>   <ul>    <li>Closed captions provide a transcription and possibly a translation of audio.</li>    <li>It may include important non-verbal information such as music cues or sound effects. It may indicate the cue's source (e.g. music, text, character).</li>    <li>Suitable for users who are deaf or when the sound is muted.</li>   </ul> </li>  <li><code>descriptions</code>   <ul>    <li>Textual description of the video content.</li>    <li>Suitable for users who are blind or where the video cannot be seen.</li>   </ul> </li>  <li><code>chapters</code>   <ul>    <li>Chapter titles are intended to be used when the user is navigating the media resource.</li>   </ul> </li>  <li><code>metadata</code>   <ul>    <li>Tracks used by scripts. Not visible to the user.</li>   </ul> </li> </ul>
 */
object kind extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: String) = new AttrPair[_kind_attr.type]("kind", v)
@inline def :=(v: Option[String]) = new OptionalAttrPair[_kind_attr.type]("kind", v)
type attrType = _kind_attr.type

}

object _kind_attr {
@inline implicit def totrackApplied(pair: AttrPair[_kind_attr.type]) = pair.asInstanceOf[AttrPair[track.tag.type]]
@inline implicit def totrackOptionalApplied(pair: OptionalAttrPair[_kind_attr.type]) = pair.asInstanceOf[OptionalAttrPair[track.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_kind_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_kind_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
