package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * The <strong>HTML <code>&lt;label&gt;</code> element</strong> represents a caption for an item in a user interface.
 * menuitem - The name of the command as shown to the user. Required when a <code>command</code> attribute is not present.
 * optgroup - The name of the group of options, which the browser can use when labeling the options in the user interface. This attribute is mandatory if this element is used.
 * menu - The name of the menu as shown to the user. Used within nested menus, to provide a label through which the submenu can be accessed. Must only be specified when the parent element is a <a title="The HTML <menu> element represents a group of commands that a user can perform or activate. This includes both list menus, which might appear across the top of a screen, as well as context menus, such as those that might appear underneath a button after it has been clicked." href="/en-US/docs/Web/HTML/Element/menu"><code>&lt;menu&gt;</code></a> in the <em>context menu</em> state.
 * option - This attribute is text for the label indicating the meaning of the option. If the <code>label</code> attribute isn't defined, its value is that of the element text content.
 * track - A user-readable title of the text track which is used by the browser when listing available text tracks.
 */
object label extends Tag with Attr {
implicit object tag extends TagElement {
  type RefType = org.scalajs.dom.html.Label
}
type tagType = tag.type

@inline def apply(mods: TagMod[tag.type]*): WithAttrs[tagType] = {
  WithAttrs("label", mods)
}
@inline def :=(v: String) = new AttrPair[_label_attr.type]("label", v)
@inline def :=(v: Option[String]) = new OptionalAttrPair[_label_attr.type]("label", v)
type attrType = _label_attr.type

}

object _label_attr {
@inline implicit def tomenuApplied(pair: AttrPair[_label_attr.type]) = pair.asInstanceOf[AttrPair[menu.tag.type]]
@inline implicit def tomenuOptionalApplied(pair: OptionalAttrPair[_label_attr.type]) = pair.asInstanceOf[OptionalAttrPair[menu.tag.type]]
             
@inline implicit def tomenuitemApplied(pair: AttrPair[_label_attr.type]) = pair.asInstanceOf[AttrPair[menuitem.tag.type]]
@inline implicit def tomenuitemOptionalApplied(pair: OptionalAttrPair[_label_attr.type]) = pair.asInstanceOf[OptionalAttrPair[menuitem.tag.type]]
             
@inline implicit def tooptgroupApplied(pair: AttrPair[_label_attr.type]) = pair.asInstanceOf[AttrPair[optgroup.tag.type]]
@inline implicit def tooptgroupOptionalApplied(pair: OptionalAttrPair[_label_attr.type]) = pair.asInstanceOf[OptionalAttrPair[optgroup.tag.type]]
             
@inline implicit def tooptionApplied(pair: AttrPair[_label_attr.type]) = pair.asInstanceOf[AttrPair[option.tag.type]]
@inline implicit def tooptionOptionalApplied(pair: OptionalAttrPair[_label_attr.type]) = pair.asInstanceOf[OptionalAttrPair[option.tag.type]]
             
@inline implicit def totrackApplied(pair: AttrPair[_label_attr.type]) = pair.asInstanceOf[AttrPair[track.tag.type]]
@inline implicit def totrackOptionalApplied(pair: OptionalAttrPair[_label_attr.type]) = pair.asInstanceOf[OptionalAttrPair[track.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_label_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_label_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
