package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * The <strong>HTML <code>&lt;legend&gt;</code> element</strong> represents a caption for the content of its parent <a title="The HTML <fieldset> element is used to group several controls as well as labels (<label>) within a web form." href="/en-US/docs/Web/HTML/Element/fieldset"><code>&lt;fieldset&gt;</code></a>.
 */
object legend extends Tag {
implicit object tag extends TagElement {
  type RefType = org.scalajs.dom.html.Legend
}
type tagType = tag.type

@inline def apply(mods: TagMod[tag.type]*): WithAttrs[tagType] = {
  WithAttrs("legend", mods)
}


}

object _legend_attr {

}
