package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * The <strong>HTML <code>&lt;link&gt;</code> element</strong> specifies relationships between the current document and an external resource. Possible uses for this element include defining a relational framework for navigation. This element is most used to link to <a title="Cascading Style Sheets" href="/en-US/docs/Glossary/CSS">style sheets</a>.
 */
object link extends Tag {
implicit object tag extends TagElement {
  type RefType = org.scalajs.dom.html.Link
}
type tagType = tag.type

@inline def apply(mods: TagMod[tag.type]*): WithAttrs[tagType] = {
  WithAttrs("link", mods)
}


}

object _link_attr {

}
