package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * Identifies a list of pre-defined options to suggest to the user. The value must be the <strong>id</strong> of a <a title="The HTML <datalist> element contains a set of <option> elements that represent the values available for other controls." href="/en-US/docs/Web/HTML/Element/datalist"><code>&lt;datalist&gt;</code></a> element in the same document. The browser displays only options that are valid values for this input element. This attribute is ignored when the <strong>type</strong> attribute's value is <code>hidden</code>, <code>checkbox</code>, <code>radio</code>, <code>file</code>, or a button type.
 */
object list extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: String) = new AttrPair[_list_attr.type]("list", v)
@inline def :=(v: Option[String]) = new OptionalAttrPair[_list_attr.type]("list", v)
type attrType = _list_attr.type

}

object _list_attr {
@inline implicit def toinputApplied(pair: AttrPair[_list_attr.type]) = pair.asInstanceOf[AttrPair[input.tag.type]]
@inline implicit def toinputOptionalApplied(pair: OptionalAttrPair[_list_attr.type]) = pair.asInstanceOf[OptionalAttrPair[input.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_list_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_list_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
