package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * video - A Boolean attribute; if specified, we will, upon reaching the end of the video, automatically seek back to the start.
 * audio - A Boolean attribute:&nbsp;if specified, will&nbsp;automatically seek back to the start&nbsp;upon reaching the end of the audio.
 */
object loop extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: Boolean) = new AttrPair[_loop_attr.type]("loop", v)
@inline def :=(v: Option[Boolean]) = new OptionalAttrPair[_loop_attr.type]("loop", v)
type attrType = _loop_attr.type
@inline implicit def boolToPairaudioApplied(attrObj: this.type) = new AttrPair[audio.tag.type]("loop", true)
@inline implicit def boolToPairvideoApplied(attrObj: this.type) = new AttrPair[video.tag.type]("loop", true)
@inline implicit def boolToPairstarApplied(attrObj: this.type) = new AttrPair[*.tag.type]("loop", true)
}

object _loop_attr {
@inline implicit def toaudioApplied(pair: AttrPair[_loop_attr.type]) = pair.asInstanceOf[AttrPair[audio.tag.type]]
@inline implicit def toaudioOptionalApplied(pair: OptionalAttrPair[_loop_attr.type]) = pair.asInstanceOf[OptionalAttrPair[audio.tag.type]]
             
@inline implicit def tovideoApplied(pair: AttrPair[_loop_attr.type]) = pair.asInstanceOf[AttrPair[video.tag.type]]
@inline implicit def tovideoOptionalApplied(pair: OptionalAttrPair[_loop_attr.type]) = pair.asInstanceOf[OptionalAttrPair[video.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_loop_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_loop_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
