package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * The upper numeric bound of the low end of the measured range. This must be greater than the minimum value (<code>min</code> attribute), and it also must be less than the high value and maximum value (<code>high</code> attribute and <code>max</code> attribute, respectively), if any are specified. If unspecified, or if less than the minimum value, the <code>low</code> value is equal to the minimum value.
 */
object low extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: String) = new AttrPair[_low_attr.type]("low", v)
@inline def :=(v: Option[String]) = new OptionalAttrPair[_low_attr.type]("low", v)
type attrType = _low_attr.type

}

object _low_attr {
@inline implicit def tometerApplied(pair: AttrPair[_low_attr.type]) = pair.asInstanceOf[AttrPair[meter.tag.type]]
@inline implicit def tometerOptionalApplied(pair: OptionalAttrPair[_low_attr.type]) = pair.asInstanceOf[OptionalAttrPair[meter.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_low_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_low_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
