package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * Specifies the URI of a resource manifest indicating resources that should be cached locally. See <a href="/en-US/docs/Web/HTML/Using_the_application_cache">Using the application cache</a> for details.
 */
object manifest extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: String) = new AttrPair[_manifest_attr.type]("manifest", v)
@inline def :=(v: Option[String]) = new OptionalAttrPair[_manifest_attr.type]("manifest", v)
type attrType = _manifest_attr.type

}

object _manifest_attr {
@inline implicit def tohtmlApplied(pair: AttrPair[_manifest_attr.type]) = pair.asInstanceOf[AttrPair[html.tag.type]]
@inline implicit def tohtmlOptionalApplied(pair: OptionalAttrPair[_manifest_attr.type]) = pair.asInstanceOf[OptionalAttrPair[html.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_manifest_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_manifest_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
