package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * The <strong>HTML <code>&lt;map&gt;</code> element</strong> is used with <a title="The HTML <area> element defines a hot-spot region on an image, and optionally associates it with a hypertext link. This element is used only within a <map> element." href="/en-US/docs/Web/HTML/Element/area"><code>&lt;area&gt;</code></a> elements to define an image map (a clickable link area).
 */
object map extends Tag {
implicit object tag extends TagElement {
  type RefType = org.scalajs.dom.html.Map
}
type tagType = tag.type

@inline def apply(mods: TagMod[tag.type]*): WithAttrs[tagType] = {
  WithAttrs("map", mods)
}


}

object _map_attr {

}
