package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * <span class="seoSummary">The <strong>HTML <code>&lt;mark&gt;</code> element</strong> represents highlighted text, i.e., a run of text marked for reference purpose, due to its <em>relevance</em> in a particular context.</span> For example it can be used in a page showing search results to highlight every instance of the searched-for word.
 */
object mark extends Tag {
implicit object tag extends TagElement {
  type RefType = org.scalajs.dom.html.Element
}
type tagType = tag.type

@inline def apply(mods: TagMod[tag.type]*): WithAttrs[tagType] = {
  WithAttrs("mark", mods)
}


}

object _mark_attr {

}
