package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * meter - The upper numeric bound of the measured range. This must be greater than the minimum value (<code>min</code> attribute), if specified. If unspecified, the maximum value is 1.
 * progress - This attribute describes how much work the task indicated by the <code>progress</code> element requires. The <code>max</code> attribute, if present, must have a value greater than zero and be a valid floating point number. The default value is 1.
 * input - The maximum (numeric or date-time) value for this item, which must not be less than its minimum (<strong>min</strong> attribute) value.
 */
object max extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: String) = new AttrPair[_max_attr.type]("max", v)
@inline def :=(v: Option[String]) = new OptionalAttrPair[_max_attr.type]("max", v)
type attrType = _max_attr.type

}

object _max_attr {
@inline implicit def toinputApplied(pair: AttrPair[_max_attr.type]) = pair.asInstanceOf[AttrPair[input.tag.type]]
@inline implicit def toinputOptionalApplied(pair: OptionalAttrPair[_max_attr.type]) = pair.asInstanceOf[OptionalAttrPair[input.tag.type]]
             
@inline implicit def tometerApplied(pair: AttrPair[_max_attr.type]) = pair.asInstanceOf[AttrPair[meter.tag.type]]
@inline implicit def tometerOptionalApplied(pair: OptionalAttrPair[_max_attr.type]) = pair.asInstanceOf[OptionalAttrPair[meter.tag.type]]
             
@inline implicit def toprogressApplied(pair: AttrPair[_max_attr.type]) = pair.asInstanceOf[AttrPair[progress.tag.type]]
@inline implicit def toprogressOptionalApplied(pair: OptionalAttrPair[_max_attr.type]) = pair.asInstanceOf[OptionalAttrPair[progress.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_max_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_max_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
