package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * source - <a class="internal" href="/en-US/docs/CSS/Media_queries">Media query</a> of the resource's intended media; this should be used only in a <a title="The HTML <picture> element is a container used to specify multiple <source> elements for a specific <img> contained in it. The browser will choose the most suitable source according to the current layout of the page (the constraints of the box the image will appear in) and the device it will be displayed on (e.g. a normal or hiDPI device.)" href="/en-US/docs/Web/HTML/Element/picture"><code>&lt;picture&gt;</code></a> element.
 * style - This attribute&nbsp;defines which media the style should apply to. Its value is a <a href="/en-US/docs/Web/Guide/CSS/Media_queries">media query</a>, which defaults to <code>all</code> if the attribute is missing.
 * link - This attribute specifies the media which the linked resource applies to. Its value must be a <a href="/en-US/docs/CSS/Media_queries">media query</a>. This attribute is mainly useful when linking to external stylesheets by allowing the user agent to pick the best adapted one for the device it runs on. <div class="note"> <strong>Usage note: </strong>  <ul>   <li>In HTML 4, this can only be a simple white-space-separated list of media description literals, i.e., <a href="/en-US/docs/CSS/@media">media types and groups</a>, where defined and allowed as values for this attribute, such as <code>print</code>, <code>screen</code>, <code>aural</code>, <code>braille</code>. HTML5 extended this to any kind of <a href="/en-US/docs/CSS/Media_queries">media queries</a>, which are a superset of the allowed values of HTML 4.</li>   <li>Browsers not supporting the <a href="/en-US/docs/CSS/Media_queries">CSS3 Media Queries</a> won't necessarily recognize the adequate link; do not forget to set fallback links, the restricted set of media queries defined in HTML 4.</li>  </ul> </div>
 * area - A hint of the media for which the linked resource was designed, for example <code>print and screen</code>. If omitted, it defaults to <code>all</code>. Use this attribute only if the <strong>href</strong> attribute is present.
 */
object media extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: String) = new AttrPair[_media_attr.type]("media", v)
@inline def :=(v: Option[String]) = new OptionalAttrPair[_media_attr.type]("media", v)
type attrType = _media_attr.type

}

object _media_attr {
@inline implicit def toareaApplied(pair: AttrPair[_media_attr.type]) = pair.asInstanceOf[AttrPair[area.tag.type]]
@inline implicit def toareaOptionalApplied(pair: OptionalAttrPair[_media_attr.type]) = pair.asInstanceOf[OptionalAttrPair[area.tag.type]]
             
@inline implicit def tolinkApplied(pair: AttrPair[_media_attr.type]) = pair.asInstanceOf[AttrPair[link.tag.type]]
@inline implicit def tolinkOptionalApplied(pair: OptionalAttrPair[_media_attr.type]) = pair.asInstanceOf[OptionalAttrPair[link.tag.type]]
             
@inline implicit def tosourceApplied(pair: AttrPair[_media_attr.type]) = pair.asInstanceOf[AttrPair[source.tag.type]]
@inline implicit def tosourceOptionalApplied(pair: OptionalAttrPair[_media_attr.type]) = pair.asInstanceOf[OptionalAttrPair[source.tag.type]]
             
@inline implicit def tostyleApplied(pair: AttrPair[_media_attr.type]) = pair.asInstanceOf[AttrPair[style.tag.type]]
@inline implicit def tostyleOptionalApplied(pair: OptionalAttrPair[_media_attr.type]) = pair.asInstanceOf[OptionalAttrPair[style.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_media_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_media_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
