package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * The <strong>HTML <code>&lt;meta&gt;</code> element</strong> represents <a title="metadata: Metadata is — in its very simplest definition — data that describes data. For example, an HTML document is data, but HTML can also contain metadata in its <head> element that describes the document — for example who wrote it, and its summary." class="glossaryLink" href="/en-US/docs/Glossary/Metadata">metadata</a> that cannot be represented by other HTML meta-related elements, like <a title="The HTML <base> element specifies the base URL to use for all relative URLs contained within a document. There can be only one <base> element in a document." href="/en-US/docs/Web/HTML/Element/base"><code>&lt;base&gt;</code></a>, <a title="The HTML <link> element specifies relationships between the current document and an external resource. Possible uses for this element include defining a relational framework for navigation. This element is most used to link to style sheets." href="/en-US/docs/Web/HTML/Element/link"><code>&lt;link&gt;</code></a>, <a title="The HTML <script> element is used to embed or reference an executable script." href="/en-US/docs/Web/HTML/Element/script"><code>&lt;script&gt;</code></a>, <a title="The HTML <style> element contains style information for a document, or part of a document. By default, the style instructions written inside that element are expected to be CSS." href="/en-US/docs/Web/HTML/Element/style"><code>&lt;style&gt;</code></a> or <a title="The HTML <title> element defines the title of the document, shown in a browser's title bar or on the page's tab. It can only contain text, and any contained tags are ignored." href="/en-US/docs/Web/HTML/Element/title"><code>&lt;title&gt;</code></a>.
 */
object meta extends Tag {
implicit object tag extends TagElement {
  type RefType = org.scalajs.dom.html.Meta
}
type tagType = tag.type

@inline def apply(mods: TagMod[tag.type]*): WithAttrs[tagType] = {
  WithAttrs("meta", mods)
}


}

object _meta_attr {

}
