package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * The <a href="/en-US/docs/Web/HTTP">HTTP</a> method that the browser uses to submit the form. Possible values are: <ul>  <li><code>post</code>: Corresponds to the HTTP <a class="external" href="https://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html#sec9.5">POST method</a> ; form data are included in the body of the form and sent to the server.</li>  <li><code>get</code>: Corresponds to the HTTP <a class="external" href="https://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html#sec9.3">GET method</a>; form data are appended to the <code>action</code> attribute URI with a '?' as separator, and the resulting URI is sent to the server. Use this method when the form has no side-effects and contains only ASCII characters.</li> </ul> <p>This value can be overridden by a <code><a href="/en-US/docs/Web/HTML/Element/button#attr-formmethod">formmethod</a></code> attribute on a <a title="The HTML <button> element represents a clickable button." href="/en-US/docs/Web/HTML/Element/button"><code>&lt;button&gt;</code></a> or <a title="The HTML <input> element is used to create interactive controls for web-based forms in order to accept data from the user." href="/en-US/docs/Web/HTML/Element/input"><code>&lt;input&gt;</code></a> element.</p>
 */
object method extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: String) = new AttrPair[_method_attr.type]("method", v)
@inline def :=(v: Option[String]) = new OptionalAttrPair[_method_attr.type]("method", v)
type attrType = _method_attr.type

}

object _method_attr {
@inline implicit def toformApplied(pair: AttrPair[_method_attr.type]) = pair.asInstanceOf[AttrPair[form.tag.type]]
@inline implicit def toformOptionalApplied(pair: OptionalAttrPair[_method_attr.type]) = pair.asInstanceOf[OptionalAttrPair[form.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_method_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_method_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
