package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * input - The minimum (numeric or date-time) value for this item, which must not be greater than its maximum (<strong>max</strong> attribute) value.
 * meter - The lower numeric bound of the measured range. This must be less than the maximum value (<code>max</code> attribute), if specified. If unspecified, the minimum value is 0.
 */
object min extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: String) = new AttrPair[_min_attr.type]("min", v)
@inline def :=(v: Option[String]) = new OptionalAttrPair[_min_attr.type]("min", v)
type attrType = _min_attr.type

}

object _min_attr {
@inline implicit def toinputApplied(pair: AttrPair[_min_attr.type]) = pair.asInstanceOf[AttrPair[input.tag.type]]
@inline implicit def toinputOptionalApplied(pair: OptionalAttrPair[_min_attr.type]) = pair.asInstanceOf[OptionalAttrPair[input.tag.type]]
             
@inline implicit def tometerApplied(pair: AttrPair[_min_attr.type]) = pair.asInstanceOf[AttrPair[meter.tag.type]]
@inline implicit def tometerOptionalApplied(pair: OptionalAttrPair[_min_attr.type]) = pair.asInstanceOf[OptionalAttrPair[meter.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_min_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_min_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
