package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * input - This Boolean attribute indicates whether the user can enter more than one value. This attribute applies when the <strong>type</strong> attribute is set to <code>email</code>&nbsp;or <code>file</code>,&nbsp;otherwise it is ignored.
 * select - This Boolean attribute indicates that multiple options can be selected in the list. If it is not specified, then only one option can be selected at a time.
 */
object multiple extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: Boolean) = new AttrPair[_multiple_attr.type]("multiple", v)
@inline def :=(v: Option[Boolean]) = new OptionalAttrPair[_multiple_attr.type]("multiple", v)
type attrType = _multiple_attr.type
@inline implicit def boolToPairinputApplied(attrObj: this.type) = new AttrPair[input.tag.type]("multiple", true)
@inline implicit def boolToPairselectApplied(attrObj: this.type) = new AttrPair[select.tag.type]("multiple", true)
@inline implicit def boolToPairstarApplied(attrObj: this.type) = new AttrPair[*.tag.type]("multiple", true)
}

object _multiple_attr {
@inline implicit def toinputApplied(pair: AttrPair[_multiple_attr.type]) = pair.asInstanceOf[AttrPair[input.tag.type]]
@inline implicit def toinputOptionalApplied(pair: OptionalAttrPair[_multiple_attr.type]) = pair.asInstanceOf[OptionalAttrPair[input.tag.type]]
             
@inline implicit def toselectApplied(pair: AttrPair[_multiple_attr.type]) = pair.asInstanceOf[AttrPair[select.tag.type]]
@inline implicit def toselectOptionalApplied(pair: OptionalAttrPair[_multiple_attr.type]) = pair.asInstanceOf[OptionalAttrPair[select.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_multiple_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_multiple_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
