package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * audio - A Boolean attribute which indicates whether the audio will be initially silenced. Its default value is false.
 * video - A Boolean attribute which indicates the default setting of the audio contained in the video. If set, the audio will be initially silenced. Its default value is false, meaning that the audio will be played when the video is played.
 */
object muted extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: Boolean) = new AttrPair[_muted_attr.type]("muted", v)
@inline def :=(v: Option[Boolean]) = new OptionalAttrPair[_muted_attr.type]("muted", v)
type attrType = _muted_attr.type
@inline implicit def boolToPairaudioApplied(attrObj: this.type) = new AttrPair[audio.tag.type]("muted", true)
@inline implicit def boolToPairvideoApplied(attrObj: this.type) = new AttrPair[video.tag.type]("muted", true)
@inline implicit def boolToPairstarApplied(attrObj: this.type) = new AttrPair[*.tag.type]("muted", true)
}

object _muted_attr {
@inline implicit def toaudioApplied(pair: AttrPair[_muted_attr.type]) = pair.asInstanceOf[AttrPair[audio.tag.type]]
@inline implicit def toaudioOptionalApplied(pair: OptionalAttrPair[_muted_attr.type]) = pair.asInstanceOf[OptionalAttrPair[audio.tag.type]]
             
@inline implicit def tovideoApplied(pair: AttrPair[_muted_attr.type]) = pair.asInstanceOf[AttrPair[video.tag.type]]
@inline implicit def tovideoOptionalApplied(pair: OptionalAttrPair[_muted_attr.type]) = pair.asInstanceOf[OptionalAttrPair[video.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_muted_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_muted_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
