package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * param - Name of the parameter.
 * a - This attribute was required for anchors defining a possible target location within a page. In HTML 4.01, <code>id</code> and <code>name</code> could be used simultaneously on a <code>&lt;a&gt;</code> element as long as they have identical values. <div class="note">  <p><strong>Usage note:</strong> This attribute is obsolete in HTML5, use the <a href="/en-US/docs/HTML/Global_attributes#attr-id">global attribute <code>id</code></a> instead.</p> </div>
 * input, keygen - The name of the control, which is submitted with the form data.
 * button - The name of the button, which is submitted with the form data.
 * iframe - A name for the embedded browsing context (or frame). This can be used as the value of the <code><strong>target</strong></code> attribute of an <a title="The HTML <a> element (or anchor element) creates a hyperlink to other web pages, files, locations within the same page, email addresses, or any other URL." href="/en-US/docs/Web/HTML/Element/a"><code>&lt;a&gt;</code></a>, <a title="The HTML <form> element represents a document section that contains interactive controls to submit information to a web server." href="/en-US/docs/Web/HTML/Element/form"><code>&lt;form&gt;</code></a> or&nbsp;<a title="The HTML <base> element specifies the base URL to use for all relative URLs contained within a document. There can be only one <base> element in a document." href="/en-US/docs/Web/HTML/Element/base"><code>&lt;base&gt;</code></a> element, or the formtarget attribute of an <a title="The HTML <input> element is used to create interactive controls for web-based forms in order to accept data from the user." href="/en-US/docs/Web/HTML/Element/input"><code>&lt;input&gt;</code></a> or <a title="The HTML <button> element represents a clickable button." href="/en-US/docs/Web/HTML/Element/button"><code>&lt;button&gt;</code></a> element. It can also be used as the value of the&nbsp;<code>windowName</code>&nbsp;parameter in the <a title="The&nbsp;Window interface's open() method loads the specified resource into the browsing context (window, frame&nbsp;or tab) with the specified name. If the name doesn't exist, then a new window is opened and the specified resource is loaded into its browsing context." href="/en-US/docs/Web/API/Window/open"><code>window.open()</code></a> method.
 * map - The name attribute gives the map a name so that it can be referenced. The attribute must be present and must have a non-empty value with no space characters. The value of the name attribute must not be a compatibility-caseless match for the value of the name attribute of another map element in the same document. If the id attribute is also specified, both attributes must have the same value.
 * img - A name for the element. It is supported in <span class="inlineIndicator htmlVer htmlVerInline"><a href="/en-US/docs/HTML">HTML 4</a></span> only for backward compatibility. Use the <code>id</code> attribute instead.
 * output - The name of the element.
 * fieldset - The name associated with the group.<br> &nbsp; <div class="note"> The label for the field set is given by the first  <a href="/en-US/docs/Web/HTML/Element/legend" title="The HTML <legend> element represents a caption for the content of its parent <fieldset>."><code>&lt;legend&gt;</code></a> element that is a child of this field set.</div>
 * form - The name of the form. In HTML 4, its use is deprecated (<code>id</code> should be used instead). It must be unique among the forms in a document and not just an empty string in HTML 5.
 * area - Define a names for the clickable area so that it can be scripted by older browsers.
 * textarea - The name of the control.
 * select - This attribute is used to specify the name of the control.
 * object - The name of valid browsing context (HTML5), or the name of the control (HTML 4).
 * meta - <p>This attribute defines the name of a piece of document-level metadata. It should not be set if one of the attributes <code><a href="/en-US/docs/Web/HTML/Element/meta#attr-itemprop">itemprop</a></code>, <code><a href="/en-US/docs/Web/HTML/Element/meta#attr-http-equiv">http-equiv</a></code> or <code><a href="/en-US/docs/Web/HTML/Element/meta#attr-charset">charset</a></code> is also set.</p> <p>This metadata name is associated with the value contained by the <code><a href="/en-US/docs/Web/HTML/Element/meta#attr-content">content</a></code> attribute. The possible values for the name attribute are:</p> <ul>  <li><code>application-name</code> defines the name of the application running in the web page.   <div class="note">   <strong>Note:</strong>    <ul>     <li>Browsers may use this to identify the application. It is different from the <a title="The HTML <title> element defines the title of the document, shown in a browser's title bar or on the page's tab. It can only contain text, and any contained tags are ignored." href="/en-US/docs/Web/HTML/Element/title"><code>&lt;title&gt;</code></a> element, which usually contain the application name, but may also contain information like the document name or a status.</li>     <li>Simple web pages shouldn't define an application-name.</li>    </ul>   </div> </li>  <li><code>author</code> defines the name of the document's author.</li>  <li><code>description</code> contains a short and accurate summary of the content of the page. Several browsers, like Firefox and Opera, use this as the default description of bookmarked pages.</li>  <li><code>generator</code> contains the identifier of the software that generated the page.</li>  <li><code>keywords</code> contains words relevant to the page's content, separated by commas.</li>  <li><code>referrer</code> <span title="This is an experimental API that should not be used in production code."><i class="icon-beaker"> </i></span> controls the <a href="/en-US/docs/Web/HTTP/Headers/Referer"><code>Referer</code> HTTP header</a> attached to requests sent from the document:   <table class="standard-table">    <caption>    Values for the     <code>content</code> attribute of     <code>&lt;meta name="referrer"&gt;</code>   </caption>    <tbody>     <tr>      <td><code>no-referrer</code></td>      <td>Do not send a HTTP <code>Referer</code> header.</td>     </tr>     <tr>      <td><code>origin</code></td>      <td>Send the <a href="/en-US/docs/Glossary/Origin">origin</a> of the document.</td>     </tr>     <tr>      <td><code>no-referrer-when-downgrade</code></td>      <td>Send the <a href="/en-US/docs/Glossary/Origin">origin</a> as referrer to URLs as secure as the current page, (https→https), but don't send a referrer to less secure URLs (https→http). This is the default behavior.</td>     </tr>     <tr>      <td><code>origin-when-crossorigin</code></td>      <td>Send the full URL (stripped of parameters) for same-origin requests, but only send the <a href="/en-US/docs/Glossary/Origin">origin</a> for other cases.</td>     </tr>     <tr>      <td><code>unsafe-URL</code></td>      <td>Send the full URL (stripped of parameters) for same-origin or cross-origin requests.</td>     </tr>    </tbody>   </table>   <div class="note">    <ul>     <li>Some browsers support the deprecated values <code>always</code>, <code>default</code>, and <code>never</code> for referrer.</li>     <li>Dynamically inserting <code>&lt;meta name="referrer"&gt;</code> (with <a href="/en-US/docs/Web/API/Document/write"><code>document.write</code></a> or <a href="/en-US/docs/Web/API/Node/appendChild"><code>appendChild</code></a>) makes referrer behavior unpredictable.</li>     <li>When several conflicting policies are defined, the no-referrer policy is applied.</li>    </ul>   </div> </li> </ul> <p>The attribute may also have a value taken from the extended list defined on <a class="external" href="https://wiki.whatwg.org/wiki/MetaExtensions">WHATWG Wiki MetaExtensions page</a>. Although none have been formally accepted yet, a few commonly used names are:</p> <p>Finally, a few names are in common use, though not in the process of being standardized:</p> <ul>  <li><code>creator</code> defines the name of the creator of the document, such as an organization or institution. If there are more than one, several <a title="The HTML <meta> element represents metadata that cannot be represented by other HTML meta-related elements, like <base>, <link>, <script>, <style> or <title>." href="/en-US/docs/Web/HTML/Element/meta"><code>&lt;meta&gt;</code></a> elements should be used.</li>  <li><code>googlebot</code>, a synonym of <code>robots</code>, but is only followed by Googlebot, the indexing crawler for Google.</li>  <li><code>publisher</code> defines the name of the document's publisher.</li>  <li><code>robots</code> defines the behavior that cooperative crawlers, or "robots", should use with the page. It is a comma-separated list of the values below:   <table class="standard-table">    <caption>    Values for the content of     <code>&lt;meta name="robots"&gt;</code>   </caption>    <thead>     <tr>      <th scope="col">Value</th>      <th scope="col">Description</th>      <th scope="col">Used by</th>     </tr>    </thead>    <tbody>     <tr>      <td><code>index</code></td>      <td>Allows the robot to index the page (default).</td>      <td>All</td>     </tr>     <tr>      <td><code>noindex</code></td>      <td>Requests the robot to not index the page.</td>      <td>All</td>     </tr>     <tr>      <td><code>follow</code></td>      <td>Allows the robot to follow the links on the page (default).</td>      <td>All</td>     </tr>     <tr>      <td><code>nofollow</code></td>      <td>Requests the robot to not follow the links on the page.</td>      <td>All</td>     </tr>     <tr>      <td><code>none</code></td>      <td>Equivalent to <code>noindex, nofollow</code></td>      <td><a class="external" href="https://support.google.com/webmasters/answer/79812">Google</a></td>     </tr>     <tr>      <td><code>noodp</code></td>      <td>Prevents using the <a class="external" href="https://www.dmoz.org/">Open Directory Project</a> description, if any, as the page description in search engine results.</td>      <td> <p><a class="external" href="https://support.google.com/webmasters/answer/35624#nodmoz">Google</a>, <a class="external" href="https://help.yahoo.com/kb/search-for-desktop/meta-tags-robotstxt-yahoo-search-sln2213.html#cont5">Yahoo</a>, <a class="external" href="https://www.bing.com/webmaster/help/which-robots-metatags-does-bing-support-5198d240">Bing</a></p> </td>     </tr>     <tr>      <td><code>noarchive</code></td>      <td>Requests the search engine not cache the page content.</td>      <td><a class="external" href="https://developers.google.com/webmasters/control-crawl-index/docs/robots_meta_tag#valid-indexing--serving-directives">Google</a>, <a class="external" href="https://help.yahoo.com/kb/search-for-desktop/SLN2213.html">Yahoo</a>, <a class="external" href="https://www.bing.com/webmaster/help/which-robots-metatags-does-bing-support-5198d240">Bing</a></td>     </tr>     <tr>      <td><code>nosnippet</code></td>      <td>Prevents displaying any description of the page in search engine results.</td>      <td><a class="external" href="https://developers.google.com/webmasters/control-crawl-index/docs/robots_meta_tag#valid-indexing--serving-directives">Google</a>, <a class="external" href="https://www.bing.com/webmaster/help/which-robots-metatags-does-bing-support-5198d240">Bing</a></td>     </tr>     <tr>      <td><code>noimageindex</code></td>      <td>Requests this page not appear as the referring page of an indexed image.</td>      <td><a class="external" href="https://developers.google.com/webmasters/control-crawl-index/docs/robots_meta_tag#valid-indexing--serving-directives">Google</a></td>     </tr>     <tr>      <td><code>nocache</code></td>      <td>Synonym of <code>noarchive</code>.</td>      <td><a class="external" href="https://www.bing.com/webmaster/help/which-robots-metatags-does-bing-support-5198d240">Bing</a></td>     </tr>    </tbody>   </table>   <div class="note">   <strong>Notes:</strong>    <ul>     <li>Only cooperative robots follow these rules. Do not expect to prevent e-mail harvesters with them.</li>     <li>The robot still needs to access the page in order to read these rules. To prevent bandwidth consumption, use a <em><a title="Robot Exclusion Protocol" class="new" href="/en-US/docs/Robot_Exclusion_Protocol">robots.txt</a></em> file.</li>     <li>If you want to remove a page, <code>noindex</code> will work, but only after the robot visits the page again. Ensure that the <code>robots.txt</code> file is not preventing revisits.</li>     <li>Some values are mutually exclusive, like <code>index</code> and <code>noindex</code>, or <code>follow</code> and <code>nofollow</code>. In these cases the robot's behavior is undefined and may vary between them.</li>     <li>Some crawler robots, like Google, Yahoo, and Bing, support the same values for the HTTP header <code>X-Robot-Tags</code>; this allows non-HTML documents like images to use these rules.</li>    </ul>   </div> </li>  <li><code>slurp</code>, a synonym of <code>robots</code>, but only for Slurp, the crawler for Yahoo Search.</li>  <li><code>viewport</code>, which gives hints about the size of the initial size of the <a title="viewport: A viewport represents a polygonal (normally rectangular) area in computer graphics that is currently being viewed. In web browser terms, it refers to the part of the document you're viewing which is currently visible in its window. Content outside the viewport is currently not displayed onscreen." class="glossaryLink" href="/en-US/docs/Glossary/viewport">viewport</a>. Used by mobile devices only.   <table class="fullwidth-table">    <caption>    Values for the content of     <code>&lt;meta name="viewport"&gt;</code>   </caption>    <thead>     <tr>      <th scope="col">Value</th>      <th scope="col">Possible subvalues</th>      <th scope="col">Description</th>     </tr>    </thead>    <tbody>     <tr>      <td><code>width</code></td>      <td>A positive integer number, or the text <code>device-width</code></td>      <td>Defines the pixel width of the viewport, or allows the viewport to adapt to the device's screen width.</td>     </tr>     <tr>      <td><code>height</code></td>      <td>A positive integer, or the text <code>device-height</code></td>      <td>Defines the height of the viewport. Not used by any browser.</td>     </tr>     <tr>      <td><code>initial-scale</code></td>      <td>A positive number between <code>0.0</code> and <code>10.0</code></td>      <td>Defines the ratio between the device width (<code>device-width</code> in portrait mode or <code>device-height</code> in landscape mode) and the viewport size.</td>     </tr>     <tr>      <td><code>maximum-scale</code></td>      <td>A positive number between <code>0.0</code> and <code>10.0</code></td>      <td>Defines the maximum amount to zoom in. It must be greater or equal to the <code>minimum-scale</code> or the behavior is undefined. Browser settings can ignore this rule, and iOS10+ ignores it by default.</td>     </tr>     <tr>      <td><code>minimum-scale</code></td>      <td>A positive number between <code>0.0</code> and <code>10.0</code></td>      <td>Defines the minimum zoom level. It must be smaller or equal to the <code>maximum-scale</code> or the behavior is undefined. Browser settings can ignore this rule, and iOS10+ ignores it by default.</td>     </tr>     <tr>      <td><code>user-scalable</code></td>      <td><code>yes</code> or <code>no</code></td>      <td>If set to <code>no</code>, the user is not able to zoom in the webpage. The default is <code>yes</code>. Browser settings can ignore this rule, and iOS10+ ignores it by default.</td>     </tr>    </tbody>   </table>   <table class="standard-table">    <thead>     <tr>      <th scope="col">Specification</th>      <th scope="col">Status</th>      <th scope="col">Comment</th>     </tr>    </thead>    <tbody>     <tr>      <td><a hreflang="en" class="external" lang="en" href="https://drafts.csswg.org/css-device-adapt/#viewport-meta">CSS Device Adaptation<br><small lang="en-US">The definition of '&lt;meta name="viewport"&gt;' in that specification.</small></a></td>      <td><span class="spec-WD">Working Draft</span></td>      <td>Non-normatively describes the Viewport META element</td>     </tr>    </tbody>   </table>   <div>   See also:    <a title="The @viewport CSS at-rule contains a set of nested descriptors in a CSS block that is delimited by curly braces. These descriptors control viewport settings, primarily on mobile devices." href="/en-US/docs/Web/CSS/@viewport"><code>@viewport</code></a>  </div>   <div class="note">   <strong>Notes:</strong>    <ul>     <li>Though unstandardized, this declaration is respected by most mobile browsers due to de-facto dominance.</li>     <li>The default values may vary between devices and browsers.</li>     <li>To learn about this declaration in Firefox for Mobile, see <a title="Mobile/Viewport meta tag" href="/en-US/docs/Mobile/Viewport_meta_tag">this article</a>.</li>    </ul>   </div> </li> </ul>
 */
object name extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: String) = new AttrPair[_name_attr.type]("name", v)
@inline def :=(v: Option[String]) = new OptionalAttrPair[_name_attr.type]("name", v)
type attrType = _name_attr.type

}

object _name_attr {
@inline implicit def toaApplied(pair: AttrPair[_name_attr.type]) = pair.asInstanceOf[AttrPair[a.tag.type]]
@inline implicit def toaOptionalApplied(pair: OptionalAttrPair[_name_attr.type]) = pair.asInstanceOf[OptionalAttrPair[a.tag.type]]
             
@inline implicit def toareaApplied(pair: AttrPair[_name_attr.type]) = pair.asInstanceOf[AttrPair[area.tag.type]]
@inline implicit def toareaOptionalApplied(pair: OptionalAttrPair[_name_attr.type]) = pair.asInstanceOf[OptionalAttrPair[area.tag.type]]
             
@inline implicit def tobuttonApplied(pair: AttrPair[_name_attr.type]) = pair.asInstanceOf[AttrPair[button.tag.type]]
@inline implicit def tobuttonOptionalApplied(pair: OptionalAttrPair[_name_attr.type]) = pair.asInstanceOf[OptionalAttrPair[button.tag.type]]
             
@inline implicit def tofieldsetApplied(pair: AttrPair[_name_attr.type]) = pair.asInstanceOf[AttrPair[fieldset.tag.type]]
@inline implicit def tofieldsetOptionalApplied(pair: OptionalAttrPair[_name_attr.type]) = pair.asInstanceOf[OptionalAttrPair[fieldset.tag.type]]
             
@inline implicit def toformApplied(pair: AttrPair[_name_attr.type]) = pair.asInstanceOf[AttrPair[form.tag.type]]
@inline implicit def toformOptionalApplied(pair: OptionalAttrPair[_name_attr.type]) = pair.asInstanceOf[OptionalAttrPair[form.tag.type]]
             
@inline implicit def toiframeApplied(pair: AttrPair[_name_attr.type]) = pair.asInstanceOf[AttrPair[iframe.tag.type]]
@inline implicit def toiframeOptionalApplied(pair: OptionalAttrPair[_name_attr.type]) = pair.asInstanceOf[OptionalAttrPair[iframe.tag.type]]
             
@inline implicit def toimgApplied(pair: AttrPair[_name_attr.type]) = pair.asInstanceOf[AttrPair[img.tag.type]]
@inline implicit def toimgOptionalApplied(pair: OptionalAttrPair[_name_attr.type]) = pair.asInstanceOf[OptionalAttrPair[img.tag.type]]
             
@inline implicit def toinputApplied(pair: AttrPair[_name_attr.type]) = pair.asInstanceOf[AttrPair[input.tag.type]]
@inline implicit def toinputOptionalApplied(pair: OptionalAttrPair[_name_attr.type]) = pair.asInstanceOf[OptionalAttrPair[input.tag.type]]
             
@inline implicit def tokeygenApplied(pair: AttrPair[_name_attr.type]) = pair.asInstanceOf[AttrPair[keygen.tag.type]]
@inline implicit def tokeygenOptionalApplied(pair: OptionalAttrPair[_name_attr.type]) = pair.asInstanceOf[OptionalAttrPair[keygen.tag.type]]
             
@inline implicit def tomapApplied(pair: AttrPair[_name_attr.type]) = pair.asInstanceOf[AttrPair[map.tag.type]]
@inline implicit def tomapOptionalApplied(pair: OptionalAttrPair[_name_attr.type]) = pair.asInstanceOf[OptionalAttrPair[map.tag.type]]
             
@inline implicit def tometaApplied(pair: AttrPair[_name_attr.type]) = pair.asInstanceOf[AttrPair[meta.tag.type]]
@inline implicit def tometaOptionalApplied(pair: OptionalAttrPair[_name_attr.type]) = pair.asInstanceOf[OptionalAttrPair[meta.tag.type]]
             
@inline implicit def toobjectApplied(pair: AttrPair[_name_attr.type]) = pair.asInstanceOf[AttrPair[`object`.tag.type]]
@inline implicit def toobjectOptionalApplied(pair: OptionalAttrPair[_name_attr.type]) = pair.asInstanceOf[OptionalAttrPair[`object`.tag.type]]
             
@inline implicit def tooutputApplied(pair: AttrPair[_name_attr.type]) = pair.asInstanceOf[AttrPair[output.tag.type]]
@inline implicit def tooutputOptionalApplied(pair: OptionalAttrPair[_name_attr.type]) = pair.asInstanceOf[OptionalAttrPair[output.tag.type]]
             
@inline implicit def toparamApplied(pair: AttrPair[_name_attr.type]) = pair.asInstanceOf[AttrPair[param.tag.type]]
@inline implicit def toparamOptionalApplied(pair: OptionalAttrPair[_name_attr.type]) = pair.asInstanceOf[OptionalAttrPair[param.tag.type]]
             
@inline implicit def toselectApplied(pair: AttrPair[_name_attr.type]) = pair.asInstanceOf[AttrPair[select.tag.type]]
@inline implicit def toselectOptionalApplied(pair: OptionalAttrPair[_name_attr.type]) = pair.asInstanceOf[OptionalAttrPair[select.tag.type]]
             
@inline implicit def totextareaApplied(pair: AttrPair[_name_attr.type]) = pair.asInstanceOf[AttrPair[textarea.tag.type]]
@inline implicit def totextareaOptionalApplied(pair: OptionalAttrPair[_name_attr.type]) = pair.asInstanceOf[OptionalAttrPair[textarea.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_name_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_name_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
