package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * style - A cryptographic nonce (number used once) to whitelist inline styles in a <a href="/en-US/docs/Web/HTTP/Headers/Content-Security-Policy/style-src">style-src Content-Security-Policy</a>. The server must generate a unique nonce value each time it transmits a policy.&nbsp;It is critical to provide an unguessable nonce, as bypassing a resource’s policy is otherwise trivial.
 * script - A cryptographic nonce (number used once) to whitelist inline scripts in a <a href="/en-US/docs/Web/HTTP/Headers/Content-Security-Policy/script-src">script-src Content-Security-Policy</a>. The server must generate a unique nonce value each time it transmits a policy.&nbsp;It is critical to provide an unguessable nonce, as bypassing a resource’s policy is otherwise trivial.
 */
object nonce extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: String) = new AttrPair[_nonce_attr.type]("nonce", v)
@inline def :=(v: Option[String]) = new OptionalAttrPair[_nonce_attr.type]("nonce", v)
type attrType = _nonce_attr.type

}

object _nonce_attr {
@inline implicit def toscriptApplied(pair: AttrPair[_nonce_attr.type]) = pair.asInstanceOf[AttrPair[script.tag.type]]
@inline implicit def toscriptOptionalApplied(pair: OptionalAttrPair[_nonce_attr.type]) = pair.asInstanceOf[OptionalAttrPair[script.tag.type]]
             
@inline implicit def tostyleApplied(pair: AttrPair[_nonce_attr.type]) = pair.asInstanceOf[AttrPair[style.tag.type]]
@inline implicit def tostyleOptionalApplied(pair: OptionalAttrPair[_nonce_attr.type]) = pair.asInstanceOf[OptionalAttrPair[style.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_nonce_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_nonce_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
