package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * dialog - Indicates that the dialog is active and available for interaction. When the open attribute is not set, it shouldn't be shown to the user.
 * details - This Boolean attribute indicates whether the details will be shown to the user on page load. Default is <code>false</code> and so details will be hidden.
 */
object open extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: Boolean) = new AttrPair[_open_attr.type]("open", v)
@inline def :=(v: Option[Boolean]) = new OptionalAttrPair[_open_attr.type]("open", v)
type attrType = _open_attr.type
@inline implicit def boolToPairdetailsApplied(attrObj: this.type) = new AttrPair[details.tag.type]("open", true)
@inline implicit def boolToPairdialogApplied(attrObj: this.type) = new AttrPair[dialog.tag.type]("open", true)
@inline implicit def boolToPairstarApplied(attrObj: this.type) = new AttrPair[*.tag.type]("open", true)
}

object _open_attr {
@inline implicit def todetailsApplied(pair: AttrPair[_open_attr.type]) = pair.asInstanceOf[AttrPair[details.tag.type]]
@inline implicit def todetailsOptionalApplied(pair: OptionalAttrPair[_open_attr.type]) = pair.asInstanceOf[OptionalAttrPair[details.tag.type]]
             
@inline implicit def todialogApplied(pair: AttrPair[_open_attr.type]) = pair.asInstanceOf[AttrPair[dialog.tag.type]]
@inline implicit def todialogOptionalApplied(pair: OptionalAttrPair[_open_attr.type]) = pair.asInstanceOf[OptionalAttrPair[dialog.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_open_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_open_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
