package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * This attribute indicates the optimal numeric value. It must be within the range (as defined by the <code>min</code> attribute and <code>max</code> attribute). When used with the <code>low</code> attribute and <code>high</code> attribute, it gives an indication where along the range is considered preferable. For example, if it is between the <code>min</code> attribute and the <code>low</code> attribute, then the lower range is considered preferred.
 */
object optimum extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: String) = new AttrPair[_optimum_attr.type]("optimum", v)
@inline def :=(v: Option[String]) = new OptionalAttrPair[_optimum_attr.type]("optimum", v)
type attrType = _optimum_attr.type

}

object _optimum_attr {
@inline implicit def tometerApplied(pair: AttrPair[_optimum_attr.type]) = pair.asInstanceOf[AttrPair[meter.tag.type]]
@inline implicit def tometerOptionalApplied(pair: OptionalAttrPair[_optimum_attr.type]) = pair.asInstanceOf[OptionalAttrPair[meter.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_optimum_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_optimum_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
