package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * <span class="seoSummary">The <strong>HTML <code>&lt;option&gt;</code> element</strong> is used to define an item contained in a <a title="The HTML <select> element represents a control that provides a menu of options:" href="/en-US/docs/Web/HTML/Element/select"><code>&lt;select&gt;</code></a>, an <a title="The HTML <optgroup> element creates a grouping of options within a <select> element." href="/en-US/docs/Web/HTML/Element/optgroup"><code>&lt;optgroup&gt;</code></a>, or a <a title="The HTML <datalist> element contains a set of <option> elements that represent the values available for other controls." href="/en-US/docs/Web/HTML/Element/datalist"><code>&lt;datalist&gt;</code></a>&nbsp;element. As such,&nbsp;<code>&lt;option&gt;</code>&nbsp;can represent menu items in popups and other lists of items in an HTML document.</span>
 */
object option extends Tag {
implicit object tag extends TagElement {
  type RefType = org.scalajs.dom.html.Option
}
type tagType = tag.type

@inline def apply(mods: TagMod[tag.type]*): WithAttrs[tagType] = {
  WithAttrs("option", mods)
}


}

object _option_attr {

}
