package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * <span class="seoSummary">The <strong>HTML <code>&lt;p&gt;</code> element</strong> represents a paragraph of text.</span> Paragraphs are usually represented in visual media as blocks of text that are separated from adjacent blocks by vertical blank space and/or first-line indentation.&nbsp;Paragraphs are <a href="/en-US/docs/Web/HTML/Block-level_elements">block-level elements</a>.
 */
object p extends Tag {
implicit object tag extends TagElement {
  type RefType = org.scalajs.dom.html.Paragraph
}
type tagType = tag.type

@inline def apply(mods: TagMod[tag.type]*): WithAttrs[tagType] = {
  WithAttrs("p", mods)
}


}

object _p_attr {

}
